/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.extension.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.extension.ExtensionException;
import org.eclipse.papyrus.core.extension.NotFoundException;
import org.eclipse.papyrus.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.core.extension.commands.CreationCommandExtensionFactory;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.core.utils.PapyrusTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationCommandRegistry
implements ICreationCommandRegistry {
    private static Map<String, CreationCommandRegistry> registriesMap = new HashMap<String, CreationCommandRegistry>();
    public static final String EDITOR_EXTENSION_ID = "papyrusDiagram";
    protected String extensionPointNamespace;
    private String icon;
    private Map<Object, CreationCommandDescriptor> creationCommandDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreationCommandRegistry getInstance(String extensionPointNamespace) {
        Map<String, CreationCommandRegistry> map = registriesMap;
        synchronized (map) {
            CreationCommandRegistry registry = registriesMap.get(extensionPointNamespace);
            if (registry == null) {
                registry = new CreationCommandRegistry(extensionPointNamespace);
                registriesMap.put(extensionPointNamespace, registry);
            }
            return registry;
        }
    }

    private CreationCommandRegistry(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
        this.initializeCreationCommandDescriptors();
    }

    @Override
    public Collection<CreationCommandDescriptor> getCommandDescriptors() {
        return this.creationCommandDescriptors.values();
    }

    @Override
    public ICreationCommand getCommand(String commandId) throws NotFoundException {
        try {
            CreationCommandDescriptor desc = this.creationCommandDescriptors.get(commandId);
            return desc.getCommand();
        }
        catch (Exception e) {
            throw new NotFoundException("No creation command registered under id '" + commandId + "'.");
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    private void initializeCreationCommandDescriptors() {
        this.creationCommandDescriptors = new HashMap<Object, CreationCommandDescriptor>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, EDITOR_EXTENSION_ID);
        CreationCommandExtensionFactory extensionReader = new CreationCommandExtensionFactory();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("creationCommand".equals(ele.getName())) {
                    CreationCommandDescriptor desc = extensionReader.createCreationCommand(ele);
                    this.creationCommandDescriptors.put(desc.commandId, desc);
                }
            }
            catch (ExtensionException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.core", e.getMessage(), (Throwable)e));
                PapyrusTrace.error("org.eclipse.papyrus.core/debug/extensionpoint", this, "Initialization creation command problem " + e);
            }
            ++n2;
        }
        PapyrusTrace.trace("org.eclipse.papyrus.core/debug/extensionpoint", this, this.creationCommandDescriptors.size() + " creationCommands loaded");
    }
}

