/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.listenerservice;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.listenerservice.IPapyrusListener;
import org.osgi.framework.Bundle;

public class ModelListenerManager
extends EContentAdapter {
    private Hashtable<String, IPapyrusListener> listenerRegistry = new Hashtable();
    private String MODELLISTENERID_EXTENSION_ID = "org.eclipse.papyrus.core.modelListener";
    private String NAME_ID = "name";
    private String REALIZATION_ID = "realization";

    public ModelListenerManager() {
        this.initializeListenerList();
    }

    private void initializeListenerList() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.MODELLISTENERID_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.inializeOneRule(configElements[i]);
            ++i;
        }
    }

    private void inializeOneRule(IConfigurationElement element) {
        String listenerName = element.getAttribute(this.NAME_ID);
        try {
            IPapyrusListener listener = (IPapyrusListener)ModelListenerManager.createExtension(element, element.getAttribute(this.REALIZATION_ID));
            this.listenerRegistry.put(listenerName, listener);
        }
        catch (Exception e) {
            Activator.log.error("- " + listenerName + " can not be loaded: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }

    public String toString() {
        String out = "ModelListener: \n";
        Enumeration<String> keyenum = this.listenerRegistry.keys();
        while (keyenum.hasMoreElements()) {
            String aKey = keyenum.nextElement();
            out = String.valueOf(out) + "- " + aKey + " (" + this.listenerRegistry.get(aKey).toString() + ")\n";
        }
        return out;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Enumeration<IPapyrusListener> papyrusListenersEnum = this.listenerRegistry.elements();
        while (papyrusListenersEnum.hasMoreElements()) {
            papyrusListenersEnum.nextElement().notifyChanged(notification);
        }
    }
}

