/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.modelsetquery;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.papyrus.core.modelsetquery.IModelSetQueryAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSetQuery {
    private static SimpleTypeCacheAdapter simpleCacheAdapter = new SimpleTypeCacheAdapter();

    public static Collection<EObject> getObjectsOfType(EObject eobjectInModelSet, EClassifier type) {
        IModelSetQueryAdapter adapter = ModelSetQuery.getExistingTypeCacheAdapter((Notifier)eobjectInModelSet);
        return adapter.getReachableObjectsOfType(eobjectInModelSet, type);
    }

    public static IModelSetQueryAdapter getExistingTypeCacheAdapter(Notifier notifier) {
        Resource resource;
        IModelSetQueryAdapter typeCacheAdapter;
        if (notifier == null) {
            return simpleCacheAdapter;
        }
        for (Adapter adapter : notifier.eAdapters()) {
            if (!(adapter instanceof IModelSetQueryAdapter)) continue;
            return (IModelSetQueryAdapter)adapter;
        }
        if (notifier instanceof EObject) {
            EObject object = (EObject)notifier;
            typeCacheAdapter = ModelSetQuery.getExistingTypeCacheAdapter((Notifier)object.eResource());
            if (typeCacheAdapter != null) {
                object.eAdapters().add((Object)((Adapter)typeCacheAdapter));
                return typeCacheAdapter;
            }
        } else if (notifier instanceof Resource && (typeCacheAdapter = ModelSetQuery.getExistingTypeCacheAdapter((Notifier)(resource = (Resource)notifier).getResourceSet())) != null) {
            if (typeCacheAdapter instanceof Adapter) {
                resource.eAdapters().add((Object)((Adapter)typeCacheAdapter));
            }
            return typeCacheAdapter;
        }
        return simpleCacheAdapter;
    }

    public static IModelSetQueryAdapter getSimpleTypeCacheAdapter() {
        return simpleCacheAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeCacheAdapter
    implements IModelSetQueryAdapter {
        private SimpleTypeCacheAdapter() {
        }

        @Override
        public Collection<EObject> getReachableObjectsOfType(EObject object, EClassifier type) {
            return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, (EClassifier)type);
        }
    }
}

