/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.modelsetquery.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.papyrus.core.modelsetquery.IFillableModelSetQueryAdapter;
import org.eclipse.papyrus.core.modelsetquery.IModelSetQueryAdapter;
import org.eclipse.papyrus.core.modelsetquery.impl.ModelSetQueryAdapterSizeMatters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSetQueryAdapterTimeMatters
extends EContentAdapter
implements IFillableModelSetQueryAdapter {
    private Map<EClassifier, Collection<EObject>> cache = Collections.synchronizedMap(new IdentityHashMap());
    private static SimpleTypeCacheAdapter simpleCacheAdapter = new SimpleTypeCacheAdapter();

    public static IModelSetQueryAdapter getExistingTypeCacheAdapter(Notifier notifier) {
        Resource resource;
        IModelSetQueryAdapter typeCacheAdapter;
        if (notifier == null) {
            return simpleCacheAdapter;
        }
        for (Adapter adapter : notifier.eAdapters()) {
            if (!(adapter instanceof ModelSetQueryAdapterSizeMatters)) continue;
            return (ModelSetQueryAdapterSizeMatters)adapter;
        }
        if (notifier instanceof EObject) {
            EObject object = (EObject)notifier;
            typeCacheAdapter = ModelSetQueryAdapterTimeMatters.getExistingTypeCacheAdapter((Notifier)object.eResource());
            if (typeCacheAdapter != null) {
                object.eAdapters().add((Object)((Adapter)typeCacheAdapter));
                return typeCacheAdapter;
            }
        } else if (notifier instanceof Resource && (typeCacheAdapter = ModelSetQueryAdapterTimeMatters.getExistingTypeCacheAdapter((Notifier)(resource = (Resource)notifier).getResourceSet())) != null) {
            if (typeCacheAdapter instanceof Adapter) {
                resource.eAdapters().add((Object)((Adapter)typeCacheAdapter));
            }
            return typeCacheAdapter;
        }
        return simpleCacheAdapter;
    }

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        if (notifier instanceof EObject) {
            EObject eobject = (EObject)notifier;
            this.addObjectInCache(eobject);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
        if (notifier instanceof EObject) {
            EObject eobject = (EObject)notifier;
            this.removeObjectFromCache(eobject);
        }
    }

    private void addObjectInCache(EObject newObj) {
        EClass eClass = newObj.eClass();
        this.putObjectInCache((EClassifier)eClass, newObj);
        for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
            this.putObjectInCache((EClassifier)eSuperClass, newObj);
        }
    }

    private void putObjectInCache(EClassifier eClassifier, EObject newObj) {
        Collection<EObject> listOfClassifiers = this.cache.get(eClassifier);
        if (listOfClassifiers == null) {
            listOfClassifiers = new HashSet<EObject>();
            this.cache.put(eClassifier, listOfClassifiers);
        }
        listOfClassifiers.add(newObj);
    }

    private void removeObjectFromCache(EObject newObj) {
        EClass eClass = newObj.eClass();
        this.removeObjectFromCache((EClassifier)eClass, newObj);
        for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
            this.removeObjectFromCache((EClassifier)eSuperClass, newObj);
        }
    }

    private void removeObjectFromCache(EClassifier eClassifier, EObject newObj) {
        Collection<EObject> listOfClassifiers = this.cache.get(eClassifier);
        if (listOfClassifiers != null) {
            listOfClassifiers.remove(newObj);
        }
        if (listOfClassifiers.isEmpty()) {
            this.cache.remove(eClassifier);
        }
    }

    @Override
    public Collection<EObject> getReachableObjectsOfType(EObject object, EClassifier type) {
        if (!this.cache.containsKey(type)) {
            this.cache.put(type, new HashSet(ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, (EClassifier)type)));
        }
        return this.cache.get(type);
    }

    public void dispose() {
        this.cache.clear();
        this.cache = null;
    }

    @Override
    public void addEntriesInCache(EClassifier type, HashSet<EObject> list) {
        for (EObject e : list) {
            this.addObjectInCache(e);
        }
    }

    @Override
    public boolean isAlreadyComputed(EClassifier type) {
        return this.cache.containsKey(type);
    }

    public static IModelSetQueryAdapter getSimpleTypeCacheAdapter() {
        return simpleCacheAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeCacheAdapter
    implements IModelSetQueryAdapter {
        private SimpleTypeCacheAdapter() {
        }

        @Override
        public Collection<EObject> getReachableObjectsOfType(EObject object, EClassifier type) {
            return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, (EClassifier)type);
        }
    }
}

