/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.multidiagram.actionbarcontributor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.extension.ExtensionException;
import org.eclipse.papyrus.core.extension.NotFoundException;
import org.eclipse.papyrus.core.multidiagram.actionbarcontributor.ActionBarContributorDescriptor;
import org.eclipse.papyrus.core.multidiagram.actionbarcontributor.ActionBarContributorExtensionFactory;
import org.eclipse.papyrus.core.multidiagram.actionbarcontributor.IActionBarContributorFactory;
import org.eclipse.papyrus.core.services.IService;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.ui.part.EditorActionBarContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBarContributorRegistry
implements IActionBarContributorFactory,
IService {
    public static final String EDITOR_EXTENSION_ID = "papyrusDiagram";
    protected String extensionPointNamespace;
    private Map<Object, ActionBarContributorDescriptor> editorContextDescriptors;

    public ActionBarContributorRegistry(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
        this.initializeEditorContextDescriptors();
    }

    @Override
    public EditorActionBarContributor getActionBarContributor(Object key) throws BackboneException {
        try {
            ActionBarContributorDescriptor desc = this.editorContextDescriptors.get(key);
            return desc.getActionBarContributor();
        }
        catch (NullPointerException e) {
            throw new NotFoundException("No ActionBarContributor registered under id '" + key + "'.");
        }
    }

    public List<EditorActionBarContributor> getActionBarContributors() throws BackboneException {
        ArrayList<EditorActionBarContributor> res = new ArrayList<EditorActionBarContributor>();
        for (ActionBarContributorDescriptor desc : this.editorContextDescriptors.values()) {
            res.add(desc.getActionBarContributor());
        }
        return res;
    }

    public void registerActionBarContributor(String contextKey, EditorActionBarContributor contributor) {
        ActionBarContributorDescriptor desc = new ActionBarContributorDescriptor();
        desc.contextId = contextKey;
        desc.instance = contributor;
        desc.contextClass = contributor.getClass();
        this.editorContextDescriptors.put(contextKey, desc);
    }

    private void initializeEditorContextDescriptors() {
        this.editorContextDescriptors = new HashMap<Object, ActionBarContributorDescriptor>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, EDITOR_EXTENSION_ID);
        ActionBarContributorExtensionFactory extensionReader = new ActionBarContributorExtensionFactory();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("actionBarContributor".equals(ele.getName())) {
                    ActionBarContributorDescriptor desc = extensionReader.createActionBarContributorDescriptor(ele);
                    if (this.editorContextDescriptors.get(desc.contextId) != null) {
                        ActionBarContributorDescriptor existingDesc = this.editorContextDescriptors.get(desc.contextId);
                        if (desc.equals(existingDesc)) {
                            Activator.log.warn("More than one ActionBarContributor is registered under the name '" + desc.contextId + "', with different parameters. Extra declaration are discarded.");
                        }
                    } else {
                        this.editorContextDescriptors.put(desc.contextId, desc);
                    }
                }
            }
            catch (ExtensionException e) {
                Activator.log.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " : contributors desc loaded  [" + this.editorContextDescriptors.size() + "]");
        }
    }

    @Override
    public void init(ServicesRegistry servicesRegistry) {
    }

    @Override
    public void startService() {
    }

    @Override
    public void disposeService() {
    }
}

