/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.core.services.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMultiException
extends ServiceException {
    private static final long serialVersionUID = 1L;
    List<Throwable> encounteredExceptions = new ArrayList<Throwable>();
    List<Object> serviceIdentifiers = new ArrayList<Object>();

    public List<Throwable> getExceptions() {
        return this.encounteredExceptions;
    }

    public ServiceMultiException() {
        super("Multiple exceptions");
    }

    public ServiceMultiException(String message) {
        super(message);
    }

    @Override
    public Throwable getCause() {
        return this.encounteredExceptions.size() > 0 ? this.encounteredExceptions.get(0) : null;
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            buffer.append(message).append('\n');
        }
        buffer.append("----- exceptions : ----------\n");
        int i = 0;
        while (i < this.encounteredExceptions.size()) {
            String msg;
            Throwable exception = this.encounteredExceptions.get(i);
            Object identifierMsg = this.serviceIdentifiers.get(i);
            if (identifierMsg != null) {
                buffer.append(identifierMsg.toString()).append(" : ");
            }
            if ((msg = exception.getMessage()) != null) {
                buffer.append(msg).append('\n');
            }
            ++i;
        }
        buffer.append("----------------------------- \n");
        return buffer.toString();
    }

    public void addException(Throwable exception) {
        this.addException("unknown", exception);
    }

    public void addException(Object identifier, Throwable exception) {
        this.encounteredExceptions.add(exception);
        this.serviceIdentifiers.add(identifier);
    }

    public void addAll(ServiceMultiException e) {
        this.encounteredExceptions.addAll(e.encounteredExceptions);
        this.serviceIdentifiers.addAll(this.serviceIdentifiers);
    }
}

