/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.services.internal;

import org.eclipse.papyrus.core.services.BadStateException;
import org.eclipse.papyrus.core.services.ServiceDescriptor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServiceState;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.services.internal.ServiceTypeEntry;

public class PojoServiceEntry
extends ServiceTypeEntry {
    private Object serviceInstance;

    public PojoServiceEntry(ServiceDescriptor serviceDescriptor) {
        super(serviceDescriptor);
        this.setState(ServiceState.registered);
    }

    public PojoServiceEntry(ServiceDescriptor descriptor, Object serviceInstance) {
        super(descriptor);
        this.serviceInstance = serviceInstance;
        this.setState(ServiceState.registered);
    }

    public Object getServiceInstance() throws ServiceException {
        if (this.serviceInstance == null) {
            throw new BadStateException("Service is not created.", this.state, this.serviceDescriptor);
        }
        return this.serviceInstance;
    }

    public void createService() throws ServiceException {
        this.checkState(ServiceState.registered);
        if (this.serviceInstance != null) {
            this.setState(ServiceState.created);
            return;
        }
        try {
            this.serviceInstance = this.instanciateService();
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.created);
    }

    public void initService(ServicesRegistry servicesRegistry) throws ServiceException {
        this.setState(ServiceState.initialized);
    }

    public void startService() throws ServiceException {
        this.setState(ServiceState.started);
    }

    public void disposeService() throws ServiceException {
        if (this.serviceInstance == null) {
            return;
        }
        this.serviceInstance = null;
        this.setState(ServiceState.disposed);
    }
}

