/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.services.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.papyrus.core.services.ServiceDescriptor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServiceState;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.services.internal.ServiceTypeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceStartupEntry {
    protected ServiceTypeEntry serviceEntry;
    protected List<ServiceStartupEntry> requiredServices;

    public ServiceStartupEntry(ServiceTypeEntry serviceEntry) {
        this.serviceEntry = serviceEntry;
    }

    public abstract void createService() throws ServiceException;

    public abstract void initService(ServicesRegistry var1) throws ServiceException;

    public abstract void startService() throws ServiceException;

    public abstract Object getServiceInstance() throws ServiceException;

    public abstract void disposeService() throws ServiceException;

    public Collection<ServiceStartupEntry> getRequiredServices() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ServiceDescriptor getDescriptor() {
        return this.serviceEntry.getDescriptor();
    }

    public ServiceState getState() {
        return this.serviceEntry.getState();
    }

    public boolean isStarted() {
        return this.serviceEntry.isStarted();
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": key=" + this.getDescriptor().getKey();
    }
}

