/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.resource.ModelException;
import org.eclipse.papyrus.resource.ModelMultiException;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelsReader;
import org.eclipse.papyrus.resource.notation.NotationUtils;
import org.eclipse.papyrus.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.resource.uml.UmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiResourceSet
extends ModelSet {
    public DiResourceSet() {
        ModelsReader reader = new ModelsReader();
        reader.readModel(this);
    }

    public Resource loadModelResource(IFile file) {
        UmlModel model = null;
        try {
            model = (UmlModel)this.loadModel("org.eclipse.papyrus.resource.uml.UmlModel", file);
        }
        catch (ModelException e) {
            return null;
        }
        return model.getResource();
    }

    public String getModelFileExtension() {
        throw new UnsupportedOperationException("deprecated method.");
    }

    public void loadResources(IFile file) {
        try {
            this.loadModels(file);
        }
        catch (ModelMultiException e) {
            e.printStackTrace();
        }
    }

    public void createModelResources(IFile newFile, String eContentType, String modelExtension) {
        if (!"org.eclipse.uml2.uml".equals(eContentType) || !"uml".equals(modelExtension)) {
            throw new UnsupportedOperationException("");
        }
        this.createsModels(newFile);
    }

    private URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public Resource getNotationResource() {
        return NotationUtils.getNotationModel(this).getResource();
    }

    public Resource getDiResource() {
        return SashModelUtils.getSashModel(this).getResource();
    }

    public Resource getAssociatedDiResource(EObject modelElement) {
        return this.getDiResource();
    }

    public Resource getAssociatedNotationResource(EObject modelElement) {
        Resource modelResource;
        if (modelElement != null && (modelResource = modelElement.eResource()) != null && !modelResource.equals(this.getModelResource())) {
            return this.getAssociatedResource(modelResource, "notation");
        }
        return this.getNotationResource();
    }

    public Resource getAssociatedModelResource(EObject modelElement) {
        if (modelElement != null && modelElement.eResource() != null) {
            return modelElement.eResource();
        }
        return this.getModelResource();
    }

    private Resource getAssociatedResource(Resource modelResource, String associatedResourceExtension) {
        URI trimmedModelURI = modelResource.getURI().trimFileExtension();
        Resource r = null;
        try {
            r = this.getResource(trimmedModelURI.appendFileExtension(associatedResourceExtension), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public Resource getModelResource() {
        return UmlUtils.getUmlModel(this).getResource();
    }

    public List<Resource> getAdditionalResources() {
        ArrayList<Resource> additionnalResources = new ArrayList<Resource>();
        for (Resource resource : this.getResources()) {
            if (resource == this.getDiResource() || resource == this.getNotationResource() || resource == this.getModelResource()) continue;
            additionnalResources.add(resource);
        }
        return additionnalResources;
    }

    public static IFile getRelatedDiFile(IFile file) {
        return DiModelUtils.getRelatedDiFile(file);
    }
}

