/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.di.DiSashModelMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.di.TransactionalDiSashModelMngr;
import org.eclipse.papyrus.sasheditor.editor.IPage;
import org.eclipse.papyrus.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    public static IMultiDiagramEditor getMultiDiagramEditor() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editor;
        }
        return null;
    }

    public static IMultiDiagramEditor getMultiDiagramEditorChecked() throws BackboneException {
        IEditorPart editor;
        try {
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (NullPointerException e) {
            throw new BackboneException("Can't get the current Eclipse Active Editor: There is no active editor at this time.");
        }
        if (editor instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editor;
        }
        throw new BackboneException("Can't get an Active Editor instance of IMultiDiagramEditor. (actual type:" + editor.getClass().getName() + ")");
    }

    public static IMultiDiagramEditor[] getMultiDiagramEditors() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        ArrayList<IMultiDiagramEditor> list = new ArrayList<IMultiDiagramEditor>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorRef.getEditor(false);
            if (editorPart instanceof IMultiDiagramEditor) {
                list.add((IMultiDiagramEditor)editorPart);
            }
            ++n2;
        }
        return list.toArray(new IMultiDiagramEditor[list.size()]);
    }

    public static IMultiDiagramEditor[] getRelatedEditors(IFile file) {
        IFile diFile = DiModelUtils.getRelatedDiFile(file);
        if (diFile == null || !diFile.exists()) {
            return new IMultiDiagramEditor[0];
        }
        IMultiDiagramEditor[] openedEditors = EditorUtils.getMultiDiagramEditors();
        if (openedEditors == null) {
            return new IMultiDiagramEditor[0];
        }
        ArrayList<IMultiDiagramEditor> list = new ArrayList<IMultiDiagramEditor>(openedEditors.length);
        IMultiDiagramEditor[] iMultiDiagramEditorArray = openedEditors;
        int n = openedEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IMultiDiagramEditor editorPart = iMultiDiagramEditorArray[n2];
            if (editorPart.getEditorInput() instanceof IFileEditorInput && diFile.equals((Object)((IFileEditorInput)editorPart.getEditorInput()).getFile())) {
                list.add(editorPart);
            }
            ++n2;
        }
        return list.toArray(new IMultiDiagramEditor[list.size()]);
    }

    public static ServicesRegistry getServiceRegistry() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        return editor == null ? null : (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
    }

    public static ServicesRegistry getServiceRegistryChecked() throws ServiceException {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor == null) {
            throw new ServiceException("Can't get ServiceRegistry");
        }
        return (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
    }

    public static ISashWindowsContentProvider getISashWindowsContentProvider() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(ISashWindowsContentProvider.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static IPageMngr getIPageMngr() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(IPageMngr.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Deprecated
    protected static IEditorPart getWorkbenchActiveEditor() {
        IMultiDiagramEditor editorPart = EditorUtils.getMultiDiagramEditor();
        if (editorPart instanceof CoreMultiDiagramEditor) {
            return editorPart;
        }
        return null;
    }

    public static IPageMngr getIPageMngr(Resource diResource) {
        return DiSashModelMngr.createIPageMngr((Resource)diResource);
    }

    public static IPageMngr getTransactionalIPageMngr(Resource diResource, TransactionalEditingDomain editingDomain) {
        return TransactionalDiSashModelMngr.createIPageMngr((Resource)diResource, (TransactionalEditingDomain)editingDomain);
    }

    public static Diagram lookupEditorActiveDiagram() {
        DiagramEditor diagEditor = EditorUtils.lookupActiveDiagramEditor();
        return diagEditor == null ? null : diagEditor.getDiagram();
    }

    public static DiagramEditor lookupActiveDiagramEditor() {
        IEditorPart activeEditor = EditorUtils.lookupActiveNestedIEditor();
        if (activeEditor instanceof DiagramEditor) {
            return (DiagramEditor)activeEditor;
        }
        return null;
    }

    public static IEditorPart lookupActiveNestedIEditor() {
        ISashWindowsContainer container = EditorUtils.getSashWindowContainer();
        return container == null ? null : container.getActiveEditor();
    }

    public static IPage lookupActiveNestedPage() {
        ISashWindowsContainer container = EditorUtils.getSashWindowContainer();
        return container == null ? null : container.getActiveSashWindowsPage();
    }

    private static ISashWindowsContainer getSashWindowContainer() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(ISashWindowsContainer.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static DiResourceSet getDiResourceSet() {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistry();
            return registry == null ? null : registry.getService(DiResourceSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain() {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistry();
            return registry == null ? null : registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException registry) {
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomainChecked() throws ServiceException {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistryChecked();
            return registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException e) {
            throw new ServiceException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(ServicesRegistry registry) {
        try {
            return registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomainChecked(ServicesRegistry registry) throws ServiceException {
        return registry.getService(TransactionalEditingDomain.class);
    }
}

