/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.utils;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.core.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ServiceUtilsForActionHandlers {
    private static final ServiceUtilsForActionHandlers instance = new ServiceUtilsForActionHandlers();

    public static final ServiceUtilsForActionHandlers getInstance() {
        return instance;
    }

    public ServicesRegistry getServiceRegistry() throws ServiceException {
        IEditorPart editor;
        try {
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (NullPointerException e) {
            throw new ServiceNotFoundException("Can't get the current Eclipse Active Editor. No ServiceRegistry found.");
        }
        ServicesRegistry serviceRegistry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
        if (serviceRegistry != null) {
            return serviceRegistry;
        }
        throw new ServiceNotFoundException("Can't get the ServiceRegistry from current Eclipse Active Editor");
    }

    public TransactionalEditingDomain getTransactionalEditingDomain() throws ServiceException {
        return this.getServiceRegistry().getService(TransactionalEditingDomain.class);
    }

    public IPageMngr getIPageMngr() throws ServiceException {
        return this.getServiceRegistry().getService(IPageMngr.class);
    }

    public ModelSet getModelSet() throws ServiceException {
        return this.getServiceRegistry().getService(ModelSet.class);
    }

    public ILifeCycleEventsProvider getILifeCycleEventsProvider() throws ServiceException {
        return this.getServiceRegistry().getService(ILifeCycleEventsProvider.class);
    }

    public ISashWindowsContainer getISashWindowsContainer() throws ServiceException {
        return this.getServiceRegistry().getService(ISashWindowsContainer.class);
    }

    public IEditorPart getNestedActiveIEditorPart() throws ServiceException {
        return this.getISashWindowsContainer().getActiveEditor();
    }
}

