/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.resource;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.resource.IModel;
import org.eclipse.papyrus.resource.IModelSnippet;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelSnippetList;

public abstract class AbstractBaseModel
implements IModel {
    private ModelSet modelSet;
    private ModelSnippetList snippets = new ModelSnippetList();
    protected Resource resource;
    protected URI resourceURI;

    public void init(ModelSet modelManager) {
        this.modelSet = modelManager;
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }

    protected ResourceSet getResourceSet() {
        return this.modelSet;
    }

    public Resource getResource() {
        return this.resource;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public abstract String getIdentifier();

    protected abstract String getModelFileExtension();

    protected boolean resourceIsSet() {
        return this.resource != null;
    }

    public void createModel(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(this.getModelFileExtension()));
        this.resource = this.getModelManager().createResource(this.resourceURI);
    }

    protected URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public void loadModel(IFile file) {
        this.loadModel(file.getFullPath().removeFileExtension());
    }

    public void loadModel(IPath fullPathWithoutExtension) {
        this.resourceURI = this.getPlatformURI(fullPathWithoutExtension.addFileExtension(this.getModelFileExtension()));
        this.resource = this.modelSet.getResource(this.resourceURI, true);
        this.snippets.performStart(this);
    }

    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    public void saveModel() throws IOException {
        this.resource.save(null);
    }

    public void changeModelPath(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(this.getModelFileExtension()));
        this.resource.setURI(this.resourceURI);
    }

    public void unload() {
        this.snippets.performDispose(this);
        if (this.resource != null) {
            this.resource.unload();
            this.resource = null;
        }
    }

    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }
}

