/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.resource.AbstractBaseModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelWithSharedResource<T extends EObject>
extends AbstractBaseModel {
    private ModelKind modelKind;

    public AbstractModelWithSharedResource(ModelKind modelKind) {
        this.modelKind = modelKind;
    }

    public AbstractModelWithSharedResource() {
        this.modelKind = ModelKind.slave;
    }

    @Override
    public void loadModel(IPath fullPathWithoutExtension) {
        this.lookupResource(fullPathWithoutExtension);
        if (this.resourceIsSet()) {
            return;
        }
        super.loadModel(fullPathWithoutExtension);
    }

    @Override
    public void createModel(IPath fullPath) {
        this.lookupResource(fullPath);
        if (this.resourceIsSet()) {
            return;
        }
        super.createModel(fullPath);
    }

    private void lookupResource(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(this.getModelFileExtension()));
        this.resource = this.getResourceSet().getResource(this.resourceURI, false);
    }

    @Override
    public void saveModel() throws IOException {
        if (this.modelKind == ModelKind.slave) {
            return;
        }
        super.saveModel();
    }

    public T getModelRoot() {
        for (EObject object : this.getResource().getContents()) {
            if (!this.isModelRoot(object)) continue;
            return (T)object;
        }
        return null;
    }

    public List<T> getModelRoots() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (EObject object : this.getResource().getContents()) {
            if (!this.isModelRoot(object)) continue;
            roots.add(object);
        }
        return roots;
    }

    protected abstract boolean isModelRoot(EObject var1);

    public void addModelRoot(T root) {
        this.getResource().getContents().add(root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModelKind {
        master,
        slave;

    }
}

