/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.resource.additional;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.resource.IModel;
import org.eclipse.papyrus.resource.IModelSnippet;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelSnippetList;

public class AdditionalResourcesModel
implements IModel {
    private ModelSet modelSet;
    private ModelSnippetList snippets = new ModelSnippetList();
    public static String MODEL_ID = "org.eclipse.papyrus.resource.additional";

    public void init(ModelSet modelManager) {
        this.modelSet = modelManager;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void createModel(IPath fullPath) {
    }

    public void loadModel(IPath path) {
        this.snippets.performStart(this);
    }

    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    public void saveModel() throws IOException {
        for (Resource r : this.modelSet.getResources()) {
            if (!this.modelSet.isAdditionalResource(r.getURI())) continue;
            TransactionalEditingDomain editingDomain = this.modelSet.getTransactionalEditingDomain();
            if (r.getContents().isEmpty() || !r.isModified() || editingDomain == null || editingDomain.isReadOnly(r) || !r.getURI().isPlatform() && !r.getURI().isFile()) continue;
            r.save(Collections.EMPTY_MAP);
        }
    }

    public void changeModelPath(IPath fullPath) {
    }

    public void unload() {
        this.snippets.performDispose(this);
        int i = 0;
        while (i < this.modelSet.getResources().size()) {
            Resource next = (Resource)this.modelSet.getResources().get(i);
            if (this.modelSet.isAdditionalResource(next.getURI())) {
                next.unload();
            }
            ++i;
        }
    }

    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }
}

