/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.activity.edit.part.interfaces.InterruptibleEdge;
import org.eclipse.papyrus.diagram.activity.request.InterruptibleEdgeRequest;

public class DeferredInterruptibleEdgeCommand
extends AbstractTransactionalCommand {
    private EditPart hostEditPart;
    private CreateConnectionViewRequest.ConnectionViewDescriptor descriptor;

    public DeferredInterruptibleEdgeCommand(TransactionalEditingDomain domain, String label, List affectedFiles, EditPart hostEditPart, CreateConnectionViewRequest.ConnectionViewDescriptor descriptor) {
        super(domain, label, affectedFiles);
        this.hostEditPart = hostEditPart;
        this.descriptor = descriptor;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object connectionEditPart = this.hostEditPart.getViewer().getEditPartRegistry().get(this.descriptor.getAdapter(View.class));
        if (connectionEditPart instanceof IGraphicalEditPart && connectionEditPart instanceof InterruptibleEdge) {
            InterruptibleEdgeRequest request = new InterruptibleEdgeRequest();
            request.setType(InterruptibleEdgeRequest.SET_INTERRUPTIBLE_EDGE);
            Command cmd = ((IGraphicalEditPart)connectionEditPart).getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                cmd.execute();
            } else {
                return CommandResult.newErrorCommandResult((String)"Unable to the the target Editpart as Interruptible Edge");
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

