/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.dialogs;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.diagram.activity.edit.helpers.ObjectFlowEditHelper;
import org.eclipse.papyrus.diagram.activity.part.Messages;
import org.eclipse.papyrus.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.common.ui.helper.HelpComponentFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreatePinsForObjectFlowDialog
extends FormDialog {
    private static final String TITLE = Messages.CreatePinsForObjectFlowDialog_Title;
    private static final String PIN_CREATION_SECTION_TITLE = Messages.CreatePinsForObjectFlowDialog_PinCreationTitle;
    private static final String NAME_LABEL = Messages.CreatePinsForObjectFlowDialog_Name;
    private static final String TYPE_LABEL = Messages.CreatePinsForObjectFlowDialog_Type;
    private static final String NAME_INITIAL_VALUE = "data";
    private ActivityNode initialSource = null;
    private ActivityNode initialTarget = null;
    private ActivityNode newSource = null;
    private ActivityNode newTarget = null;
    private Text creationNameText = null;
    private String creationName = "data";
    private ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    private Text creationTypeText = null;
    private Button creationTypeButton = null;
    private Type creationType = null;

    public CreatePinsForObjectFlowDialog(Shell shell, ActivityNode source, ActivityNode target) {
        super(shell);
        this.initialSource = source;
        this.initialTarget = target;
    }

    public int open() {
        if (ObjectFlowEditHelper.insertPinForStartingNewObjectFlow(this.initialSource) && ObjectFlowEditHelper.insertPinForEndingNewObjectFlow(this.initialTarget)) {
            return super.open();
        }
        boolean needInformation = false;
        if (ObjectFlowEditHelper.insertPinForStartingNewObjectFlow(this.initialSource)) {
            this.newSource = this.createSource((Action)this.initialSource, this.initialTarget);
            if (this.newSource == null) {
                needInformation = true;
            }
        } else {
            this.newSource = this.initialSource;
        }
        if (ObjectFlowEditHelper.insertPinForEndingNewObjectFlow(this.initialTarget)) {
            this.newTarget = this.createTarget((Action)this.initialTarget, this.initialSource);
            if (this.newTarget == null) {
                needInformation = true;
            }
        } else {
            this.newTarget = this.initialTarget;
        }
        if (needInformation) {
            return super.open();
        }
        return 0;
    }

    private InputPin createTarget(Action parentAction, ActivityNode objectFlowSource) {
        if (objectFlowSource instanceof Pin) {
            return this.createInputPin(parentAction, objectFlowSource.getName(), ((Pin)objectFlowSource).getType());
        }
        return null;
    }

    private OutputPin createSource(Action parentAction, ActivityNode objectFlowTarget) {
        if (objectFlowTarget instanceof Pin) {
            return this.createOutputPin(parentAction, objectFlowTarget.getName(), ((Pin)objectFlowTarget).getType());
        }
        return null;
    }

    private InputPin createInputPin(Action parentAction, String name, Type type) {
        InputPin result = UMLFactory.eINSTANCE.createInputPin();
        result.setName(name);
        result.setType(type);
        ObjectFlowEditHelper.insertInputPin(parentAction, result);
        return result;
    }

    private OutputPin createOutputPin(Action parentAction, String name, Type type) {
        OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
        result.setName(name);
        result.setType(type);
        ObjectFlowEditHelper.insertOutputPin(parentAction, result);
        return result;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(TITLE);
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createPinCreationSection(scrolledForm.getBody(), toolkit);
        this.hookListeners();
        scrolledForm.reflow(true);
    }

    private void createPinCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = PIN_CREATION_SECTION_TITLE;
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ImageHyperlink componentHelp = HelpComponentFactory.createHelpComponent((Composite)lSection, (FormToolkit)pToolkit, (String)Messages.CreatePinsForObjectFlowDialog_PinCreationHelp, (boolean)true);
        lSection.setTextClient((Control)componentHelp);
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        pToolkit.createLabel(lBody, NAME_LABEL, 0);
        this.creationNameText = pToolkit.createText(lBody, NAME_INITIAL_VALUE, 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.creationNameText.setFocus();
        pToolkit.createLabel(lBody, TYPE_LABEL, 0);
        this.creationTypeText = pToolkit.createText(lBody, "", 2056);
        this.creationTypeText.setLayoutData((Object)new GridData(768));
        this.creationTypeButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = UMLElementTypes.getImage((ENamedElement)UMLPackage.eINSTANCE.getClass_());
        this.creationTypeButton.setImage(image);
        this.creationTypeButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void hookListeners() {
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreatePinsForObjectFlowDialog.this.creationName = CreatePinsForObjectFlowDialog.this.creationNameText.getText();
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectTypeBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreatePinsForObjectFlowDialog.this.handleChooseType();
            }
        };
        this.creationTypeButton.addSelectionListener((SelectionListener)selectTypeBtnListener);
    }

    private void handleChooseType() {
        Collection types = ModelSetQuery.getObjectsOfType((EObject)this.initialSource, (EClassifier)UMLPackage.eINSTANCE.getType());
        HashSet typesSet = new HashSet(types);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.labelProvider);
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        dialog.setFilter("*");
        dialog.setMultipleSelection(false);
        dialog.setElements((Object[])typesSet.toArray(new EObject[typesSet.size()]));
        if (dialog.open() == 0) {
            this.creationType = (Type)dialog.getFirstResult();
            this.creationTypeText.setText(this.labelProvider.getText((Object)this.creationType));
        }
    }

    protected void okPressed() {
        if (this.newSource == null) {
            this.newSource = this.createOutputPin((Action)((OpaqueAction)this.initialSource), this.creationName, this.creationType);
        }
        if (this.newTarget == null) {
            this.newTarget = this.createInputPin((Action)((OpaqueAction)this.initialTarget), this.creationName, this.creationType);
        }
        super.okPressed();
    }

    public ActivityNode getSource() {
        return this.newSource;
    }

    public ActivityNode getTarget() {
        return this.newTarget;
    }
}

