/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.part;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.activity.edit.parts.ObjectFlowTransformationEditPart;
import org.eclipse.papyrus.diagram.activity.edit.policies.BehaviorPropertyNodeEditPolicy;
import org.eclipse.papyrus.diagram.activity.figures.ActivityEdgeFigure;
import org.eclipse.papyrus.diagram.activity.figures.WrappedLabel;
import org.eclipse.papyrus.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.papyrus.diagram.common.figure.node.ILabelFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.ObjectFlow;

public class CustomObjectFlowTransformationEditPart
extends ObjectFlowTransformationEditPart {
    public CustomObjectFlowTransformationEditPart(View view) {
        super(view);
    }

    protected IFigure createFigurePrim() {
        return new CustomLinkAndCornerBentWithTextFigure();
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        if (figure instanceof CustomLinkAndCornerBentWithTextFigure) {
            return ((CustomLinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else if (figure instanceof CustomLinkAndCornerBentWithTextFigure) {
            ((CustomLinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        if (figure instanceof CustomLinkAndCornerBentWithTextFigure) {
            return ((CustomLinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else if (figure instanceof CustomLinkAndCornerBentWithTextFigure) {
            ((CustomLinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    protected void setVisibility(boolean vis) {
        Behavior transformation;
        EObject element = this.resolveSemanticElement();
        if (element instanceof ObjectFlow && (transformation = ((ObjectFlow)element).getTransformation()) == null) {
            vis = false;
        }
        super.setVisibility(vis);
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
                this.refreshVisibility();
            }
        }
        super.handleNotificationEvent(event);
    }

    public class CustomLinkAndCornerBentWithTextFigure
    extends CornerBentFigure {
        final Color THIS_BACK = new Color(null, 248, 249, 214);
        private WrappedLabel fCornerBentContent;
        private PolylineShape fLinkToBehaviorProperty;

        public CustomLinkAndCornerBentWithTextFigure() {
            this.setBackgroundColor(this.THIS_BACK);
            this.createContents();
        }

        public boolean containsPoint(int x, int y) {
            if (this.isVisible()) {
                return super.containsPoint(x, y);
            }
            return false;
        }

        private void createContents() {
            this.fCornerBentContent = new WrappedLabel();
            this.add((IFigure)this.fCornerBentContent);
            this.fLinkToBehaviorProperty = new PolylineShape();
            this.fLinkToBehaviorProperty.setLineWidth(1);
            this.fLinkToBehaviorProperty.setLineStyle(2);
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    CustomLinkAndCornerBentWithTextFigure.this.refreshLinkToBehaviorProperty();
                }
            });
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.getLinkToBehaviorProperty().setVisible(visible);
        }

        private void refreshLinkToBehaviorProperty() {
            if (this.getLinkToBehaviorProperty().getParent() == null) {
                this.getParent().add((IFigure)this.getLinkToBehaviorProperty());
            }
            if (this.getParent() != null && this.getParent() instanceof ActivityEdgeFigure) {
                Point parentCenter = CustomObjectFlowTransformationEditPart.this.getReferencePoint();
                Rectangle currentBounds = this.getBounds();
                Point end = BehaviorPropertyNodeEditPolicy.getAppropriateBorderPoint(parentCenter, currentBounds);
                Rectangle linkBounds = new Rectangle(parentCenter, end);
                this.getLinkToBehaviorProperty().setStart(parentCenter.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setEnd(end.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setBounds(linkBounds);
            }
        }

        public WrappedLabel getCornerBentContent() {
            return this.fCornerBentContent;
        }

        public PolylineShape getLinkToBehaviorProperty() {
            return this.fLinkToBehaviorProperty;
        }
    }
}

