/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.diagram.activity.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.diagram.activity.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.activity.providers.UMLParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.Package;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof UMLNavigatorItem && !this.isOwnView(((UMLNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return UMLDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 3038: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?DecisionNode", UMLElementTypes.DecisionNode_3038);
            }
            case 3086: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?CreateObjectAction", UMLElementTypes.CreateObjectAction_3086);
            }
            case 3025: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3025);
            }
            case 3087: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3087);
            }
            case 3091: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?AddStructuralFeatureValueAction", UMLElementTypes.AddStructuralFeatureValueAction_3091);
            }
            case 3020: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3020);
            }
            case 3081: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ReadSelfAction", UMLElementTypes.ReadSelfAction_3081);
            }
            case 3015: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3015);
            }
            case 3048: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3048);
            }
            case 3073: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?SequenceNode", UMLElementTypes.SequenceNode_3073);
            }
            case 3061: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3061);
            }
            case 3074: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ExpansionNode", UMLElementTypes.ExpansionNode_3074);
            }
            case 3016: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3016);
            }
            case 3101: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3101);
            }
            case 3080: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Comment", UMLElementTypes.Comment_3080);
            }
            case 3005: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActivityFinalNode", UMLElementTypes.ActivityFinalNode_3005);
            }
            case 3040: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ForkNode", UMLElementTypes.ForkNode_3040);
            }
            case 3021: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3021);
            }
            case 3065: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?StructuredActivityNode", UMLElementTypes.StructuredActivityNode_3065);
            }
            case 3085: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?NamedElement", UMLElementTypes.NamedElement_3085);
            }
            case 3055: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3055);
            }
            case 3049: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3049);
            }
            case 3003: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Constraint", UMLElementTypes.Constraint_3003);
            }
            case 3069: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ConditionalNode", UMLElementTypes.ConditionalNode_3069);
            }
            case 3096: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3096);
            }
            case 3089: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3089);
            }
            case 3013: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3013);
            }
            case 3098: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3098);
            }
            case 3094: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3094);
            }
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/uml2/3.0.0/UML?Package", UMLElementTypes.Package_1000);
            }
            case 3032: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?IntervalConstraint", UMLElementTypes.IntervalConstraint_3032);
            }
            case 3037: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?TimeConstraint", UMLElementTypes.TimeConstraint_3037);
            }
            case 4005: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?ExceptionHandler", UMLElementTypes.ExceptionHandler_4005);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/uml2/3.0.0/UML?Activity", UMLElementTypes.Activity_2001);
            }
            case 3059: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActivityParameterNode", UMLElementTypes.ActivityParameterNode_3059);
            }
            case 3064: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3064);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Parameter", UMLElementTypes.Parameter_3001);
            }
            case 4004: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?ControlFlow", UMLElementTypes.ControlFlow_4004);
            }
            case 3067: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActivityPartition", UMLElementTypes.ActivityPartition_3067);
            }
            case 3050: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3050);
            }
            case 3036: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?TimeConstraint", UMLElementTypes.TimeConstraint_3036);
            }
            case 3103: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3103);
            }
            case 3062: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3062);
            }
            case 3063: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?AcceptEventAction", UMLElementTypes.AcceptEventAction_3063);
            }
            case 3097: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ReadVariableAction", UMLElementTypes.ReadVariableAction_3097);
            }
            case 3088: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ReadStructuralFeatureAction", UMLElementTypes.ReadStructuralFeatureAction_3088);
            }
            case 3008: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?CallBehaviorAction", UMLElementTypes.CallBehaviorAction_3008);
            }
            case 3035: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_3035);
            }
            case 3054: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3054);
            }
            case 3018: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3018);
            }
            case 3010: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?CallOperationAction", UMLElementTypes.CallOperationAction_3010);
            }
            case 3041: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?JoinNode", UMLElementTypes.JoinNode_3041);
            }
            case 3104: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?CentralBufferNode", UMLElementTypes.CentralBufferNode_3104);
            }
            case 3075: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ExpansionNode", UMLElementTypes.ExpansionNode_3075);
            }
            case 3053: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3053);
            }
            case 3068: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InterruptibleActivityRegion", UMLElementTypes.InterruptibleActivityRegion_3068);
            }
            case 3014: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3014);
            }
            case 3083: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Activity", UMLElementTypes.Activity_3083);
            }
            case 3004: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InitialNode", UMLElementTypes.InitialNode_3004);
            }
            case 3033: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?IntervalConstraint", UMLElementTypes.IntervalConstraint_3033);
            }
            case 3084: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3084);
            }
            case 3102: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?BroadcastSignalAction", UMLElementTypes.BroadcastSignalAction_3102);
            }
            case 3011: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Constraint", UMLElementTypes.Constraint_3011);
            }
            case 3019: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3019);
            }
            case 3099: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?AddVariableValueAction", UMLElementTypes.AddVariableValueAction_3099);
            }
            case 3042: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?SendObjectAction", UMLElementTypes.SendObjectAction_3042);
            }
            case 3007: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OpaqueAction", UMLElementTypes.OpaqueAction_3007);
            }
            case 3092: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3092);
            }
            case 3095: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?DestroyObjectAction", UMLElementTypes.DestroyObjectAction_3095);
            }
            case 3051: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3051);
            }
            case 3060: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3060);
            }
            case 3023: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3023);
            }
            case 3022: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3022);
            }
            case 3052: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?SendSignalAction", UMLElementTypes.SendSignalAction_3052);
            }
            case 4001: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?Action?localPrecondition", UMLElementTypes.ActionLocalPrecondition_4001);
            }
            case 3071: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?LoopNode", UMLElementTypes.LoopNode_3071);
            }
            case 3078: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?DataStoreNode", UMLElementTypes.DataStoreNode_3078);
            }
            case 3100: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3100);
            }
            case 3093: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3093);
            }
            case 3047: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3047);
            }
            case 3076: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValueSpecificationAction", UMLElementTypes.ValueSpecificationAction_3076);
            }
            case 4006: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?Comment?annotatedElement", UMLElementTypes.CommentAnnotatedElement_4006);
            }
            case 3026: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ActionInputPin", UMLElementTypes.ActionInputPin_3026);
            }
            case 4003: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?ObjectFlow", UMLElementTypes.ObjectFlow_4003);
            }
            case 3090: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3090);
            }
            case 3006: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?FlowFinalNode", UMLElementTypes.FlowFinalNode_3006);
            }
            case 3046: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3046);
            }
            case 3002: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Constraint", UMLElementTypes.Constraint_3002);
            }
            case 3027: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?InputPin", UMLElementTypes.InputPin_3027);
            }
            case 3012: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Constraint", UMLElementTypes.Constraint_3012);
            }
            case 3039: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?MergeNode", UMLElementTypes.MergeNode_3039);
            }
            case 3017: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ValuePin", UMLElementTypes.ValuePin_3017);
            }
            case 4002: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?Action?localPostcondition", UMLElementTypes.ActionLocalPostcondition_4002);
            }
            case 3024: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3024);
            }
            case 3034: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_3034);
            }
            case 3070: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?ExpansionRegion", UMLElementTypes.ExpansionRegion_3070);
            }
            case 3077: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?OutputPin", UMLElementTypes.OutputPin_3077);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = UMLDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && UMLElementTypes.isKnownElementType(elementType)) {
            image = UMLElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 3038: {
                return this.getDecisionNode_3038Text(view);
            }
            case 3086: {
                return this.getCreateObjectAction_3086Text(view);
            }
            case 3025: {
                return this.getValuePin_3025Text(view);
            }
            case 3087: {
                return this.getOutputPin_3087Text(view);
            }
            case 3091: {
                return this.getAddStructuralFeatureValueAction_3091Text(view);
            }
            case 3020: {
                return this.getOutputPin_3020Text(view);
            }
            case 3081: {
                return this.getReadSelfAction_3081Text(view);
            }
            case 3015: {
                return this.getValuePin_3015Text(view);
            }
            case 3048: {
                return this.getInputPin_3048Text(view);
            }
            case 3073: {
                return this.getSequenceNode_3073Text(view);
            }
            case 3061: {
                return this.getActionInputPin_3061Text(view);
            }
            case 3074: {
                return this.getExpansionNode_3074Text(view);
            }
            case 3016: {
                return this.getActionInputPin_3016Text(view);
            }
            case 3101: {
                return this.getInputPin_3101Text(view);
            }
            case 3080: {
                return this.getComment_3080Text(view);
            }
            case 3005: {
                return this.getActivityFinalNode_3005Text(view);
            }
            case 3040: {
                return this.getForkNode_3040Text(view);
            }
            case 3021: {
                return this.getActionInputPin_3021Text(view);
            }
            case 3065: {
                return this.getStructuredActivityNode_3065Text(view);
            }
            case 3085: {
                return this.getNamedElement_3085Text(view);
            }
            case 3055: {
                return this.getInputPin_3055Text(view);
            }
            case 3049: {
                return this.getValuePin_3049Text(view);
            }
            case 3003: {
                return this.getConstraint_3003Text(view);
            }
            case 3069: {
                return this.getConditionalNode_3069Text(view);
            }
            case 3096: {
                return this.getInputPin_3096Text(view);
            }
            case 3089: {
                return this.getInputPin_3089Text(view);
            }
            case 3013: {
                return this.getInputPin_3013Text(view);
            }
            case 3098: {
                return this.getOutputPin_3098Text(view);
            }
            case 3094: {
                return this.getOutputPin_3094Text(view);
            }
            case 1000: {
                return this.getPackage_1000Text(view);
            }
            case 3032: {
                return this.getIntervalConstraint_3032Text(view);
            }
            case 3037: {
                return this.getTimeConstraint_3037Text(view);
            }
            case 4005: {
                return this.getExceptionHandler_4005Text(view);
            }
            case 2001: {
                return this.getActivity_2001Text(view);
            }
            case 3059: {
                return this.getActivityParameterNode_3059Text(view);
            }
            case 3064: {
                return this.getOutputPin_3064Text(view);
            }
            case 3001: {
                return this.getParameter_3001Text(view);
            }
            case 4004: {
                return this.getControlFlow_4004Text(view);
            }
            case 3067: {
                return this.getActivityPartition_3067Text(view);
            }
            case 3050: {
                return this.getActionInputPin_3050Text(view);
            }
            case 3036: {
                return this.getTimeConstraint_3036Text(view);
            }
            case 3103: {
                return this.getInputPin_3103Text(view);
            }
            case 3062: {
                return this.getInputPin_3062Text(view);
            }
            case 3063: {
                return this.getAcceptEventAction_3063Text(view);
            }
            case 3097: {
                return this.getReadVariableAction_3097Text(view);
            }
            case 3088: {
                return this.getReadStructuralFeatureAction_3088Text(view);
            }
            case 3008: {
                return this.getCallBehaviorAction_3008Text(view);
            }
            case 3035: {
                return this.getDurationConstraint_3035Text(view);
            }
            case 3054: {
                return this.getValuePin_3054Text(view);
            }
            case 3018: {
                return this.getActionInputPin_3018Text(view);
            }
            case 3010: {
                return this.getCallOperationAction_3010Text(view);
            }
            case 3041: {
                return this.getJoinNode_3041Text(view);
            }
            case 3104: {
                return this.getCentralBufferNode_3104Text(view);
            }
            case 3075: {
                return this.getExpansionNode_3075Text(view);
            }
            case 3053: {
                return this.getActionInputPin_3053Text(view);
            }
            case 3068: {
                return this.getInterruptibleActivityRegion_3068Text(view);
            }
            case 3014: {
                return this.getOutputPin_3014Text(view);
            }
            case 3083: {
                return this.getActivity_3083Text(view);
            }
            case 3004: {
                return this.getInitialNode_3004Text(view);
            }
            case 3033: {
                return this.getIntervalConstraint_3033Text(view);
            }
            case 3084: {
                return this.getOutputPin_3084Text(view);
            }
            case 3102: {
                return this.getBroadcastSignalAction_3102Text(view);
            }
            case 3011: {
                return this.getConstraint_3011Text(view);
            }
            case 3019: {
                return this.getInputPin_3019Text(view);
            }
            case 3099: {
                return this.getAddVariableValueAction_3099Text(view);
            }
            case 3042: {
                return this.getSendObjectAction_3042Text(view);
            }
            case 3007: {
                return this.getOpaqueAction_3007Text(view);
            }
            case 3092: {
                return this.getInputPin_3092Text(view);
            }
            case 3095: {
                return this.getDestroyObjectAction_3095Text(view);
            }
            case 3051: {
                return this.getInputPin_3051Text(view);
            }
            case 3060: {
                return this.getValuePin_3060Text(view);
            }
            case 3023: {
                return this.getInputPin_3023Text(view);
            }
            case 3022: {
                return this.getValuePin_3022Text(view);
            }
            case 3052: {
                return this.getSendSignalAction_3052Text(view);
            }
            case 4001: {
                return this.getActionLocalPrecondition_4001Text(view);
            }
            case 3071: {
                return this.getLoopNode_3071Text(view);
            }
            case 3078: {
                return this.getDataStoreNode_3078Text(view);
            }
            case 3100: {
                return this.getInputPin_3100Text(view);
            }
            case 3093: {
                return this.getInputPin_3093Text(view);
            }
            case 3047: {
                return this.getActionInputPin_3047Text(view);
            }
            case 3076: {
                return this.getValueSpecificationAction_3076Text(view);
            }
            case 4006: {
                return this.getCommentAnnotatedElement_4006Text(view);
            }
            case 3026: {
                return this.getActionInputPin_3026Text(view);
            }
            case 4003: {
                return this.getObjectFlow_4003Text(view);
            }
            case 3090: {
                return this.getOutputPin_3090Text(view);
            }
            case 3006: {
                return this.getFlowFinalNode_3006Text(view);
            }
            case 3046: {
                return this.getValuePin_3046Text(view);
            }
            case 3002: {
                return this.getConstraint_3002Text(view);
            }
            case 3027: {
                return this.getInputPin_3027Text(view);
            }
            case 3012: {
                return this.getConstraint_3012Text(view);
            }
            case 3039: {
                return this.getMergeNode_3039Text(view);
            }
            case 3017: {
                return this.getValuePin_3017Text(view);
            }
            case 4002: {
                return this.getActionLocalPostcondition_4002Text(view);
            }
            case 3024: {
                return this.getOutputPin_3024Text(view);
            }
            case 3034: {
                return this.getDurationConstraint_3034Text(view);
            }
            case 3070: {
                return this.getExpansionRegion_3070Text(view);
            }
            case 3077: {
                return this.getOutputPin_3077Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getActionInputPin_3047Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3047, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5051));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5051");
        return "";
    }

    private String getExpansionRegion_3070Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ExpansionRegion_3070, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5120));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5120");
        return "";
    }

    private String getOutputPin_3064Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3064, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5077));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5077");
        return "";
    }

    private String getActionInputPin_3026Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3026, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5022));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5022");
        return "";
    }

    private String getActivityPartition_3067Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActivityPartition_3067, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5118));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5118");
        return "";
    }

    private String getReadStructuralFeatureAction_3088Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ReadStructuralFeatureAction_3088, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5153));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5153");
        return "";
    }

    private String getSequenceNode_3073Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.SequenceNode_3073, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5123));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5123");
        return "";
    }

    private String getIntervalConstraint_3033Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.IntervalConstraint_3033, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5037));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5037");
        return "";
    }

    private String getSendSignalAction_3052Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.SendSignalAction_3052, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5060));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5060");
        return "";
    }

    private String getSendObjectAction_3042Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.SendObjectAction_3042, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5059));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5059");
        return "";
    }

    private String getInputPin_3062Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3062, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5076));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5076");
        return "";
    }

    private String getExpansionNode_3075Text(View view) {
        ExpansionNode domainModelElement = (ExpansionNode)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3075");
        return "";
    }

    private String getDataStoreNode_3078Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DataStoreNode_3078, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5127));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5127");
        return "";
    }

    private String getDestroyObjectAction_3095Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DestroyObjectAction_3095, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5163));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5163");
        return "";
    }

    private String getValuePin_3060Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3060, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5072));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5072");
        return "";
    }

    private String getTimeConstraint_3036Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeConstraint_3036, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5040));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5040");
        return "";
    }

    private String getActionInputPin_3018Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3018, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5014));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5014");
        return "";
    }

    private String getOutputPin_3094Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3094, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5158));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5158");
        return "";
    }

    private String getDurationConstraint_3034Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_3034, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5038));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5038");
        return "";
    }

    private String getCentralBufferNode_3104Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.CentralBufferNode_3104, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5176));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5176");
        return "";
    }

    private String getInputPin_3023Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3023, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5019));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5019");
        return "";
    }

    private String getMergeNode_3039Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.MergeNode_3039, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5099));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5099");
        return "";
    }

    private String getInputPin_3096Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3096, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5161));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5161");
        return "";
    }

    private String getForkNode_3040Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ForkNode_3040, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5100));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5100");
        return "";
    }

    private String getCommentAnnotatedElement_4006Text(View view) {
        return "";
    }

    private String getActionLocalPostcondition_4002Text(View view) {
        return "";
    }

    private String getOpaqueAction_3007Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OpaqueAction_3007, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5003");
        return "";
    }

    private String getInputPin_3019Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3019, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5015));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5015");
        return "";
    }

    private String getComment_3080Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Comment_3080, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5138));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5138");
        return "";
    }

    private String getDecisionNode_3038Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DecisionNode_3038, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5043));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5043");
        return "";
    }

    private String getDurationConstraint_3035Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_3035, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5039));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5039");
        return "";
    }

    private String getCallBehaviorAction_3008Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.CallBehaviorAction_3008, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5004));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5004");
        return "";
    }

    private String getOutputPin_3090Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3090, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5151));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5151");
        return "";
    }

    private String getJoinNode_3041Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.JoinNode_3041, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5042));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5042");
        return "";
    }

    private String getValuePin_3054Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3054, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5063));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5063");
        return "";
    }

    private String getAcceptEventAction_3063Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.AcceptEventAction_3063, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5078));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5078");
        return "";
    }

    private String getNamedElement_3085Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.NamedElement_3085, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5129));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5129");
        return "";
    }

    private String getActionInputPin_3061Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3061, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5074));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5074");
        return "";
    }

    private String getExceptionHandler_4005Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ExceptionHandler_4005, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6012));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6012");
        return "";
    }

    private String getCreateObjectAction_3086Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.CreateObjectAction_3086, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5148));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5148");
        return "";
    }

    private String getConstraint_3003Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_3003, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(3003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3003");
        return "";
    }

    private String getActivity_3083Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Activity_3083, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5142));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5142");
        return "";
    }

    private String getIntervalConstraint_3032Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.IntervalConstraint_3032, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5036));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5036");
        return "";
    }

    private String getValuePin_3017Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3017, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5013));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5013");
        return "";
    }

    private String getValuePin_3015Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3015, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5011));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5011");
        return "";
    }

    private String getActivityParameterNode_3059Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActivityParameterNode_3059, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5071));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5071");
        return "";
    }

    private String getInputPin_3027Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3027, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5023));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5023");
        return "";
    }

    private String getOutputPin_3098Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3098, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5164));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5164");
        return "";
    }

    private String getInputPin_3051Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3051, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5058));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5058");
        return "";
    }

    private String getReadSelfAction_3081Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ReadSelfAction_3081, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5139));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5139");
        return "";
    }

    private String getOutputPin_3084Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3084, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5144));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5144");
        return "";
    }

    private String getInputPin_3093Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3093, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5156));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5156");
        return "";
    }

    private String getValuePin_3049Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3049, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5054));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5054");
        return "";
    }

    private String getTimeConstraint_3037Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeConstraint_3037, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5041));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5041");
        return "";
    }

    private String getValuePin_3046Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3046, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5049));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5049");
        return "";
    }

    private String getValuePin_3022Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3022, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5018));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5018");
        return "";
    }

    private String getActionInputPin_3021Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3021, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5017));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5017");
        return "";
    }

    private String getInputPin_3101Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3101, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5169));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5169");
        return "";
    }

    private String getInputPin_3089Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3089, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5149));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5149");
        return "";
    }

    private String getActivity_2001Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Activity_2001, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getConditionalNode_3069Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ConditionalNode_3069, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5119));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5119");
        return "";
    }

    private String getValuePin_3025Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValuePin_3025, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5021));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5021");
        return "";
    }

    private String getFlowFinalNode_3006Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.FlowFinalNode_3006, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5082));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5082");
        return "";
    }

    private String getConstraint_3002Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_3002, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(3002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3002");
        return "";
    }

    private String getActionInputPin_3050Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3050, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5056));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5056");
        return "";
    }

    private String getOutputPin_3020Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3020, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5016));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5016");
        return "";
    }

    private String getControlFlow_4004Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ControlFlow_4004, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6003");
        return "";
    }

    private String getInputPin_3013Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3013, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5009));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5009");
        return "";
    }

    private String getStructuredActivityNode_3065Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.StructuredActivityNode_3065, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5117));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5117");
        return "";
    }

    private String getInputPin_3092Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3092, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5154));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5154");
        return "";
    }

    private String getPackage_1000Text(View view) {
        Package domainModelElement = (Package)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getConstraint_3011Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_3011, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5007));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5007");
        return "";
    }

    private String getBroadcastSignalAction_3102Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.BroadcastSignalAction_3102, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5175));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5175");
        return "";
    }

    private String getInputPin_3103Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3103, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5172));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5172");
        return "";
    }

    private String getOutputPin_3014Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3014, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5010));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5010");
        return "";
    }

    private String getExpansionNode_3074Text(View view) {
        ExpansionNode domainModelElement = (ExpansionNode)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3074");
        return "";
    }

    private String getInterruptibleActivityRegion_3068Text(View view) {
        return "";
    }

    private String getOutputPin_3087Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3087, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5146));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5146");
        return "";
    }

    private String getActionLocalPrecondition_4001Text(View view) {
        return "";
    }

    private String getInputPin_3055Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3055, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5065));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5065");
        return "";
    }

    private String getActionInputPin_3016Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3016, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5012));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5012");
        return "";
    }

    private String getAddVariableValueAction_3099Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.AddVariableValueAction_3099, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5171));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5171");
        return "";
    }

    private String getAddStructuralFeatureValueAction_3091Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.AddStructuralFeatureValueAction_3091, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5160));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5160");
        return "";
    }

    private String getInputPin_3048Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3048, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5053));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5053");
        return "";
    }

    private String getObjectFlow_4003Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ObjectFlow_4003, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getInputPin_3100Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InputPin_3100, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5167));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5167");
        return "";
    }

    private String getReadVariableAction_3097Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ReadVariableAction_3097, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5166));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5166");
        return "";
    }

    private String getCallOperationAction_3010Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.CallOperationAction_3010, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5006));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5006");
        return "";
    }

    private String getActivityFinalNode_3005Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActivityFinalNode_3005, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5081));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5081");
        return "";
    }

    private String getValueSpecificationAction_3076Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ValueSpecificationAction_3076, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5126));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5126");
        return "";
    }

    private String getOutputPin_3024Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3024, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5020));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5020");
        return "";
    }

    private String getActionInputPin_3053Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.ActionInputPin_3053, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5061));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5061");
        return "";
    }

    private String getConstraint_3012Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_3012, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5008));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5008");
        return "";
    }

    private String getInitialNode_3004Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InitialNode_3004, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5080));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5080");
        return "";
    }

    private String getParameter_3001Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Parameter_3001, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(3001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3001");
        return "";
    }

    private String getLoopNode_3071Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.LoopNode_3071, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5121));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5121");
        return "";
    }

    private String getOutputPin_3077Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.OutputPin_3077, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5124));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5124");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLActivityDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }
}

