/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionInputFlowParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String DECISION_INPUT_FLOW_LABEL = "<<decisionInputFlow>>";

    public DecisionInputFlowParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public DecisionInputFlowParser(EAttribute[] features) {
        super(features);
    }

    public DecisionInputFlowParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getActivity_IsSingleExecution()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        ObjectFlow decisionInputFlow;
        ActivityNode target;
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof ObjectFlow && (target = ((ObjectFlow)obj).getTarget()) instanceof DecisionNode && obj.equals(decisionInputFlow = ((DecisionNode)target).getDecisionInputFlow())) {
            return DECISION_INPUT_FLOW_LABEL;
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof ObjectFlow) {
            ObjectFlow flow = (ObjectFlow)element;
            semanticElementsBeingParsed.add(flow);
            if (flow.getTarget() instanceof DecisionNode) {
                DecisionNode decision = (DecisionNode)flow.getTarget();
                semanticElementsBeingParsed.add(decision);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getActivityEdge_Target().equals(feature) || UMLPackage.eINSTANCE.getDecisionNode_DecisionInputFlow().equals(feature);
    }
}

