/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.CentralBufferNode;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class ObjectNodeParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String CENTRAL_BUFFER = "<<centralBuffer>>".concat(System.getProperty("line.separator"));
    private static final String DATASTORE_PREFIX = "<<datastore>>".concat(System.getProperty("line.separator"));
    private static final String UNTYPED_PARAMETER_FORMAT = "%s";
    private static final String TYPED_PARAMETER_FORMAT = "%s: %s";
    private static final String STATE_FORMAT = System.getProperty("line.separator").concat("[%s]");
    private static final String STATE_SEPARATOR = ", ";

    public ObjectNodeParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    public ObjectNodeParser(EAttribute[] features) {
        super(features);
    }

    public ObjectNodeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    public String getPrintString(IAdaptable element, int flags) {
        StringBuffer result = new StringBuffer();
        Object adapter = element.getAdapter(EObject.class);
        if (adapter instanceof CentralBufferNode) {
            if (adapter instanceof DataStoreNode) {
                result.append(DATASTORE_PREFIX);
            } else {
                result.append(CENTRAL_BUFFER);
            }
        }
        if (adapter instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)adapter;
            String name = objectNode.getName();
            if (objectNode.getType() != null) {
                String type = objectNode.getType().getName();
                result.append(String.format(TYPED_PARAMETER_FORMAT, name, type));
            } else {
                result.append(String.format(UNTYPED_PARAMETER_FORMAT, name));
            }
            StringBuffer stateLabel = new StringBuffer();
            for (State state : objectNode.getInStates()) {
                String stateName = state.getName();
                if (stateName == null) {
                    stateName = "";
                }
                if ("".equals(stateName)) continue;
                if (stateLabel.length() > 0) {
                    stateLabel.append(STATE_SEPARATOR);
                }
                stateLabel.append(stateName);
            }
            if (stateLabel.length() > 0) {
                result.append(String.format(STATE_FORMAT, stateLabel.toString()));
            }
        }
        return result.toString();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        ObjectNode objectNode = null;
        if (element instanceof ObjectNode) {
            objectNode = (ObjectNode)element;
            semanticElementsBeingParsed.add(objectNode);
            if (objectNode.getType() != null) {
                semanticElementsBeingParsed.add(objectNode.getType());
            }
            if (objectNode.getInStates() != null && !objectNode.getInStates().isEmpty()) {
                semanticElementsBeingParsed.addAll((Collection<Object>)objectNode.getInStates());
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getObjectNode_InState().equals(feature);
    }
}

