/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.diagram.common.commands.SetValueSpecificationValueCommand;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActionInputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.ReadSelfAction;
import org.eclipse.uml2.uml.ReadVariableAction;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValuePin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.ValueSpecificationAction;
import org.eclipse.uml2.uml.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinValueParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String SELF_KEYWORD = "self";

    public PinValueParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public PinValueParser(EAttribute[] features) {
        super(features);
    }

    public PinValueParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        return this.getPrintString(adapter, flags);
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object obj = adapter.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)obj);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (obj instanceof ValuePin) {
            ValuePin pin = (ValuePin)obj;
            ValueSpecification valueSpec = pin.getValue();
            if (valueSpec != null) {
                CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
                command.compose((IUndoableOperation)new CommandProxy((Command)new SetValueSpecificationValueCommand(valueSpec, newString)));
                return command;
            }
        } else if (obj instanceof ActionInputPin) {
            ActionInputPin pin = (ActionInputPin)obj;
            Action action = pin.getFromAction();
            if (action instanceof ReadVariableAction) {
                Variable variable = ((ReadVariableAction)action).getVariable();
                if (variable != null) {
                    CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
                    command.compose((IUndoableOperation)this.getModificationCommand((EObject)variable, UMLPackage.eINSTANCE.getNamedElement_Name(), newString));
                    return command;
                }
            } else {
                ValueSpecification valueSpec;
                if (action instanceof ReadSelfAction) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (action instanceof ValueSpecificationAction && (valueSpec = ((ValueSpecificationAction)action).getValue()) != null) {
                    CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
                    command.compose((IUndoableOperation)new CommandProxy((Command)new SetValueSpecificationValueCommand(valueSpec, newString)));
                    return command;
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String valueLabel = " ";
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof ValuePin) {
            String value;
            ValuePin pin = (ValuePin)obj;
            ValueSpecification valueSpec = pin.getValue();
            if (valueSpec != null && (value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpec)) != null) {
                valueLabel = value;
            }
        } else if (obj instanceof ActionInputPin) {
            String value;
            ValueSpecification valueSpec;
            ActionInputPin pin = (ActionInputPin)obj;
            Action action = pin.getFromAction();
            if (action instanceof ReadVariableAction) {
                String value2;
                Variable variable = ((ReadVariableAction)action).getVariable();
                if (variable != null && (value2 = variable.getName()) != null) {
                    valueLabel = value2;
                }
            } else if (action instanceof ReadSelfAction) {
                valueLabel = SELF_KEYWORD;
            } else if (action instanceof ValueSpecificationAction && (valueSpec = ((ValueSpecificationAction)action).getValue()) != null && (value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpec)) != null) {
                valueLabel = value;
            }
        }
        if (valueLabel.length() == 0) {
            valueLabel = " ";
        }
        return valueLabel;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof Pin) {
            Pin pin = (Pin)element;
            semanticElementsBeingParsed.add(pin);
            if (pin instanceof ValuePin) {
                ValueSpecification valueSpec = ((ValuePin)pin).getValue();
                if (valueSpec != null) {
                    semanticElementsBeingParsed.add(valueSpec);
                }
            } else if (pin instanceof ActionInputPin) {
                ValueSpecification valueSpec;
                Action action = ((ActionInputPin)pin).getFromAction();
                if (action != null) {
                    semanticElementsBeingParsed.add(action);
                }
                if (action instanceof ReadVariableAction) {
                    Variable variable = ((ReadVariableAction)action).getVariable();
                    if (variable != null) {
                        semanticElementsBeingParsed.add(variable);
                    }
                } else if (action instanceof ValueSpecificationAction && (valueSpec = ((ValueSpecificationAction)action).getValue()) != null) {
                    semanticElementsBeingParsed.add(valueSpec);
                }
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getValuePin_Value().equals(feature) || UMLPackage.eINSTANCE.getActionInputPin_FromAction().equals(feature) || UMLPackage.eINSTANCE.getVariableAction_Variable().equals(feature) || UMLPackage.eINSTANCE.getValueSpecificationAction_Value().equals(feature) || ValueSpecification.class.isAssignableFrom(feature.getContainerClass());
    }
}

