/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.edit.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.clazz.part.UMLDiagramUpdater;
import org.eclipse.papyrus.diagram.clazz.part.UMLLinkDescriptor;
import org.eclipse.papyrus.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.common.util.CommandUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreRelatedLinksCommand
extends AbstractTransactionalCommand {
    protected List<?> adapters;
    protected Diagram diagram;
    protected DiagramEditPart host;

    public RestoreRelatedLinksCommand(DiagramEditPart diagramEditPart, List<?> selection) {
        super(diagramEditPart.getEditingDomain(), "Restore related links", null);
        this.host = diagramEditPart;
        this.diagram = this.host.getDiagramView();
        this.adapters = selection;
    }

    private void cleanAdd(Collection<UMLLinkDescriptor> result, View view, List<?> descriptors) {
        for (Object object : descriptors) {
            UMLLinkDescriptor descriptor;
            if (!(object instanceof UMLLinkDescriptor) || this.cleanContains(result, descriptor = (UMLLinkDescriptor)object) || !this.isOwner(view, descriptor)) continue;
            result.add(descriptor);
        }
    }

    private boolean cleanContains(Collection<? extends UMLLinkDescriptor> collection, UMLLinkDescriptor umlLinkDescriptor) {
        for (UMLLinkDescriptor uMLLinkDescriptor : collection) {
            UMLLinkDescriptor descriptor;
            if (!(uMLLinkDescriptor instanceof UMLLinkDescriptor) || (descriptor = uMLLinkDescriptor).getModelElement() != umlLinkDescriptor.getModelElement() || descriptor.getSource() != umlLinkDescriptor.getSource() || descriptor.getDestination() != umlLinkDescriptor.getDestination() || descriptor.getVisualID() != umlLinkDescriptor.getVisualID()) continue;
            return true;
        }
        return false;
    }

    protected Collection<? extends UMLLinkDescriptor> collectPartRelatedLinks(View view, Map<EObject, View> domain2NotationMap) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        if (!domain2NotationMap.containsKey(view.getElement())) {
            List<UMLLinkDescriptor> outgoingDescriptors = UMLDiagramUpdater.getOutgoingLinks(view);
            this.cleanAdd(result, view, outgoingDescriptors);
            List<UMLLinkDescriptor> incomingDescriptors = UMLDiagramUpdater.getIncomingLinks(view);
            this.cleanAdd(result, view, incomingDescriptors);
        }
        if (!domain2NotationMap.containsKey(view.getElement()) || view.getEAnnotation("Shortcut") == null) {
            domain2NotationMap.put(view.getElement(), view);
        }
        return result;
    }

    protected void createRelatedLinks(Collection<? extends UMLLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        this.mapModel((View)this.diagram, domain2NotationMap);
        for (UMLLinkDescriptor uMLLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(uMLLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(uMLLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(uMLLinkDescriptor.getSemanticAdapter(), null, -1, false, this.host.getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            CommandUtil.executeCommand((Command)cmd, (IGraphicalEditPart)this.host);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.host().refresh();
        for (Object object : this.adapters) {
            if (object instanceof IAdaptable) {
                IAdaptable ad = (IAdaptable)object;
                View view = (View)ad.getAdapter(View.class);
                if (view == null) continue;
                this.refreshRelatedLinks(view);
                continue;
            }
            if (!(object instanceof View)) continue;
            this.refreshRelatedLinks((View)object);
        }
        return CommandResult.newOKCommandResult();
    }

    protected EditPart getEditPart(EObject domainModelElement, Map<? extends EObject, ? extends View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.host.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    protected Collection<? extends UMLLinkDescriptor> getLinkDescriptorToProcess(View notationView, Map<EObject, View> domain2NotationMap) {
        Collection<? extends UMLLinkDescriptor> linkDescriptors = this.collectPartRelatedLinks(notationView, domain2NotationMap);
        LinkedList<Edge> existingLinks = new LinkedList<Edge>();
        for (Object edge : notationView.getTargetEdges()) {
            if (!(edge instanceof Edge) || existingLinks.contains(edge)) continue;
            existingLinks.add((Edge)edge);
        }
        for (Object edge : notationView.getSourceEdges()) {
            if (!(edge instanceof Edge) || existingLinks.contains(edge)) continue;
            existingLinks.add((Edge)edge);
        }
        this.setViewVisible(existingLinks);
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<? extends UMLLinkDescriptor> LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        return linkDescriptors;
    }

    protected final IGraphicalEditPart host() {
        return this.host;
    }

    private boolean isOwner(View view, UMLLinkDescriptor descriptor) {
        EObject source = descriptor.getSource();
        EObject dest = descriptor.getDestination();
        if (source != null && source.equals(view.getElement())) {
            return true;
        }
        return dest != null && dest.equals(view.getElement());
    }

    protected void mapModel(View view, Map<EObject, View> domain2NotationMap) {
        if (!"PapyrusUMLClassDiagram".equals(UMLVisualIDRegistry.getModelID(view))) {
            return;
        }
        if (!(UMLDiagramUpdater.getOutgoingLinks(view).isEmpty() && UMLDiagramUpdater.getIncomingLinks(view).isEmpty() || domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null)) {
            domain2NotationMap.put(view.getElement(), view);
        }
        EList children = view.getChildren();
        for (View child : children) {
            this.mapModel(child, domain2NotationMap);
        }
        EList sourceEdges = view.getSourceEdges();
        for (View edge : sourceEdges) {
            this.mapModel(edge, domain2NotationMap);
        }
    }

    protected void refreshRelatedLinks(View notationView) {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<? extends UMLLinkDescriptor> linkDescriptors = this.getLinkDescriptorToProcess(notationView, domain2NotationMap);
        this.createRelatedLinks(linkDescriptors, domain2NotationMap);
    }

    protected void setViewVisible(Collection<? extends View> views) {
        for (View view : views) {
            SetPropertyCommand cmd;
            if (view.isVisible() || (cmd = new SetPropertyCommand(this.host.getEditingDomain(), "Restore related linksCommand show view", (IAdaptable)new EObjectAdapter((EObject)view), Properties.ID_ISVISIBLE, (Object)Boolean.TRUE)) == null || !cmd.canExecute()) continue;
            CommandUtil.executeCommand((Command)new ICommandProxy((ICommand)cmd), (IGraphicalEditPart)this.host);
        }
    }
}

