/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.clazz.custom.command.AssociationClassViewCreateCommand;
import org.eclipse.papyrus.diagram.clazz.custom.command.CustomDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.diagram.clazz.custom.command.PropertyCommandForAssociation;
import org.eclipse.papyrus.diagram.clazz.edit.commands.PropertyForComponentCreateCommand;
import org.eclipse.papyrus.diagram.clazz.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.ui.toolbox.LookForElement;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class AssociationClassHelper
extends ElementHelper {
    public static EObject createAssociationClass(TransactionalEditingDomain domain, Type source, Type target, Package container) {
        AssociationClass association = UMLFactory.eINSTANCE.createAssociationClass();
        CreateElementRequest request = new CreateElementRequest(domain, (EObject)source, UMLElementTypes.Property_3002, UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute());
        PropertyForComponentCreateCommand c = new PropertyForComponentCreateCommand(request);
        LookForElement.getCommandStack().execute((Command)new ICommandProxy((ICommand)c));
        assert (c.getCommandResult() == null);
        assert (c.getCommandResult().getReturnValue() == null);
        Property targetProperty = (Property)c.getCommandResult().getReturnValue();
        targetProperty.setType(target);
        targetProperty.setName(target.getName().toLowerCase());
        targetProperty.setLower(1);
        targetProperty.setUpper(1);
        request = new CreateElementRequest(domain, (EObject)association, UMLElementTypes.Property_3002, UMLPackage.eINSTANCE.getAssociation_OwnedEnd());
        c = new PropertyCommandForAssociation(request);
        LookForElement.getCommandStack().execute((Command)new ICommandProxy((ICommand)c));
        assert (c.getCommandResult() == null);
        assert (c.getCommandResult().getReturnValue() == null);
        Property sourceProperty = (Property)c.getCommandResult().getReturnValue();
        sourceProperty.setType(source);
        sourceProperty.setName(source.getName().toLowerCase());
        sourceProperty.setLower(1);
        sourceProperty.setUpper(1);
        EList memberEnds = association.getMemberEnds();
        if (memberEnds.indexOf(sourceProperty) >= 0) {
            association.getMemberEnds().move(0, (Object)sourceProperty);
        } else {
            association.getMemberEnds().add(0, (Object)sourceProperty);
        }
        if (memberEnds.indexOf(targetProperty) >= 0) {
            association.getMemberEnds().move(1, (Object)targetProperty);
        } else {
            association.getMemberEnds().add(1, (Object)targetProperty);
        }
        container.getPackagedElements().add((Object)association);
        ElementInitializers.getInstance().init_AssociationClass_2013(association);
        return association;
    }

    public AssociationClassHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command dropAssociationClass(AssociationClass associationClass, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        CreateCommand endNodeCreationCommand;
        CreateViewRequest.ViewDescriptor _descriptor;
        CompositeCommand cc = new CompositeCommand("drop");
        ArrayList endToDisplay = new ArrayList(associationClass.getMemberEnds());
        GraphicalEditPart[] endEditPart = new GraphicalEditPart[associationClass.getMemberEnds().size()];
        Iterator iteratorProp = endToDisplay.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            Object sourceEditPart = null;
            Property currentEnd = (Property)iteratorProp.next();
            Collection editPartSet = viewer.getEditPartRegistry().values();
            Iterator editPartIterator = editPartSet.iterator();
            while (editPartIterator.hasNext() && sourceEditPart == null) {
                EditPart currentEditPart = (EditPart)editPartIterator.next();
                if (currentEditPart instanceof CompartmentEditPart || !(currentEditPart instanceof GraphicalEditPart) || !currentEnd.getType().equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
                endEditPart[index] = (GraphicalEditPart)currentEditPart;
            }
            ++index;
        }
        CreateConnectionViewRequest.ConnectionViewDescriptor viewBranchDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Association_4019, ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), diagramPreferencesHint);
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)associationClass);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, null, -1, false, diagramPreferencesHint);
        CreateCommand associationClassNodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, containerView);
        cc.compose((IUndoableOperation)associationClassNodeCreationCommand);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)associationClassNodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100));
        cc.compose((IUndoableOperation)setBoundsCommand);
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (endEditPart[0] == null) {
            _descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)endToDisplay.get(0)), Node.class, null, -1, false, diagramPreferencesHint);
            endNodeCreationCommand = new CreateCommand(this.getEditingDomain(), _descriptor, containerView);
            cc.compose((IUndoableOperation)endNodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)endNodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y + 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)endNodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, endEditPart[0].getModel());
        }
        if (endEditPart[1] == null) {
            _descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)endToDisplay.get(2)), Node.class, null, -1, false, diagramPreferencesHint);
            endNodeCreationCommand = new CreateCommand(this.getEditingDomain(), _descriptor, containerView);
            cc.compose((IUndoableOperation)endNodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)endNodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            targetAdapter = (IAdaptable)endNodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, endEditPart[1].getModel());
        }
        CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.AssociationClass_4017, ((IHintedType)UMLElementTypes.AssociationClass_4017).getSemanticHint(), diagramPreferencesHint);
        CustomDeferredCreateConnectionViewCommand associationcClassLinkCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.AssociationClass_4017).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, viewer, diagramPreferencesHint, viewDescriptor, null);
        associationcClassLinkCommand.setElement((EObject)associationClass);
        cc.compose((IUndoableOperation)associationcClassLinkCommand);
        CreateConnectionViewRequest.ConnectionViewDescriptor dashedLineViewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Link_4016, ((IHintedType)UMLElementTypes.Link_4016).getSemanticHint(), diagramPreferencesHint);
        CustomDeferredCreateConnectionViewCommand dashedLineCmd = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Link_4016).getSemanticHint(), (IAdaptable)associationcClassLinkCommand.getCommandResult().getReturnValue(), (IAdaptable)associationClassNodeCreationCommand.getCommandResult().getReturnValue(), viewer, diagramPreferencesHint, dashedLineViewDescriptor, null);
        dashedLineCmd.setElement((EObject)associationClass);
        cc.compose((IUndoableOperation)dashedLineCmd);
        return new ICommandProxy((ICommand)cc);
    }

    public Command getAssociationClassElementCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        if (command instanceof ICommandProxy) {
            GraphicalEditPart sourceEditPart = (GraphicalEditPart)createConnectionViewAndElementRequest.getSourceEditPart();
            Point p = sourceEditPart.getFigure().getBounds().getTopRight().getCopy();
            sourceEditPart.getFigure().translateToAbsolute((Translatable)p);
            int edgeCount = sourceEditPart.getNotationView().getSourceEdges().size();
            int offset = edgeCount * 50 - 100;
            p = p.translate(100, offset);
            GraphicalEditPart parent = (GraphicalEditPart)sourceEditPart.getParent();
            AssociationClassViewCreateCommand assCommand = new AssociationClassViewCreateCommand(createConnectionViewAndElementRequest, this.getEditingDomain(), (View)parent.getModel(), sourceEditPart.getViewer(), sourceEditPart.getDiagramPreferencesHint(), p);
            command = command.chain((Command)new ICommandProxy((ICommand)assCommand));
            IAdaptable associationClassLinkViewAdapter = (IAdaptable)createConnectionViewAndElementRequest.getNewObject();
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Link_4016, ((INotationType)UMLElementTypes.Link_4016).getSemanticHint(), sourceEditPart.getDiagramPreferencesHint());
            CustomDeferredCreateConnectionViewCommand dashedLineCmd = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Link_4016).getSemanticHint(), associationClassLinkViewAdapter, null, sourceEditPart.getViewer(), sourceEditPart.getDiagramPreferencesHint(), viewDescriptor, (ICommand)assCommand);
            command = command.chain((Command)new ICommandProxy((ICommand)dashedLineCmd));
            return command;
        }
        return null;
    }
}

