/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.clazz.custom.command.AssociationDiamonViewCreateCommand;
import org.eclipse.papyrus.diagram.clazz.custom.command.CustomDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.diagram.clazz.custom.command.PropertyCommandForAssociation;
import org.eclipse.papyrus.diagram.clazz.custom.helper.AssociationEndSourceLabelHelper;
import org.eclipse.papyrus.diagram.clazz.custom.helper.AssociationEndTargetLabelHelper;
import org.eclipse.papyrus.diagram.clazz.custom.providers.GraphicalAssociationBranchViewCommand;
import org.eclipse.papyrus.diagram.clazz.edit.parts.AssociationBranchEditPart;
import org.eclipse.papyrus.diagram.clazz.edit.parts.AssociationNodeEditPart;
import org.eclipse.papyrus.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.common.commands.DeleteLinkDuringCreationCommand;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class MultiAssociationHelper
extends ElementHelper {
    private static final String SEMANTIC_BRANCH = "Semantic_Branch_Style";

    public static Property getPropertyToListen(Edge associationBranchView, Association association) {
        Property semanticBranch = MultiAssociationHelper.getSemanticBranchEnd((View)associationBranchView);
        if (semanticBranch != null) {
            return semanticBranch;
        }
        Classifier target = (Classifier)associationBranchView.getTarget().getElement();
        Property propertyToDisplay = null;
        for (Property currentProperty : association.getMemberEnds()) {
            if (!currentProperty.getType().equals(target)) continue;
            propertyToDisplay = currentProperty;
        }
        return propertyToDisplay;
    }

    public static void createSemanticBranchStyles(View view) {
        EObjectValueStyle semanticbranchStyle = NotationFactory.eINSTANCE.createEObjectValueStyle();
        semanticbranchStyle.setName(SEMANTIC_BRANCH);
        view.getStyles().add((Object)semanticbranchStyle);
    }

    public static Property getSemanticBranchEnd(View view) {
        EObjectValueStyle semanticStyle = (EObjectValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getEObjectValueStyle(), SEMANTIC_BRANCH);
        return semanticStyle == null ? null : (Property)semanticStyle.getEObjectValue();
    }

    public static void setSemanticBranchEnd(View view, Property end) {
        EObjectValueStyle semanticStyle = (EObjectValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getEObjectValueStyle(), SEMANTIC_BRANCH);
        semanticStyle.setEObjectValue((EObject)end);
    }

    public MultiAssociationHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command displayAllBranchesCommand(AssociationNodeEditPart associationNodeEditPart) {
        CompoundCommand command = new CompoundCommand();
        Association association = (Association)associationNodeEditPart.resolveSemanticElement();
        ArrayList endToDisplay = new ArrayList(association.getMemberEnds());
        for (EditPart currentEditPart : associationNodeEditPart.getSourceConnections()) {
            if (!(currentEditPart instanceof AssociationBranchEditPart)) continue;
            endToDisplay.remove(MultiAssociationHelper.getPropertyToListen((Edge)((AssociationBranchEditPart)currentEditPart).getModel(), association));
        }
        Iterator iteratorProp = endToDisplay.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            ++index;
            EditPart sourceEditPart = null;
            Property currentEnd = (Property)iteratorProp.next();
            Collection editPartSet = associationNodeEditPart.getViewer().getEditPartRegistry().values();
            Iterator editPartIterator = editPartSet.iterator();
            while (editPartIterator.hasNext() && sourceEditPart == null) {
                EditPart currentEditPart = (EditPart)editPartIterator.next();
                if (currentEditPart instanceof CompartmentEditPart || !(currentEditPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) || !currentEnd.getType().equals(((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
                sourceEditPart = currentEditPart;
            }
            CreateConnectionViewRequest.ConnectionViewDescriptor viewBranchDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Association_4019, ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), associationNodeEditPart.getDiagramPreferencesHint());
            if (sourceEditPart != null) {
                CustomDeferredCreateConnectionViewCommand aBranchCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, associationNodeEditPart.getModel()), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewBranchDescriptor, null);
                aBranchCommand.setElement((EObject)association);
                command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
                continue;
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)currentEnd.getType());
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, null, -1, false, associationNodeEditPart.getDiagramPreferencesHint());
            CreateCommand nodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, (View)((View)associationNodeEditPart.getModel()).eContainer());
            command.add((Command)new ICommandProxy((ICommand)nodeCreationCommand));
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(associationNodeEditPart.getLocation().x + 200, associationNodeEditPart.getLocation().y + index * 100));
            command.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            CustomDeferredCreateConnectionViewCommand aBranchCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, associationNodeEditPart.getModel()), (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), associationNodeEditPart.getViewer(), associationNodeEditPart.getDiagramPreferencesHint(), viewBranchDescriptor, null);
            aBranchCommand.setElement((EObject)association);
            command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
        }
        return command;
    }

    public Command dropMutliAssociation(Association association, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        CompoundCommand command = new CompoundCommand();
        ArrayList endToDisplay = new ArrayList(association.getMemberEnds());
        AssociationDiamonViewCreateCommand nodeCreation = new AssociationDiamonViewCreateCommand(this.getEditingDomain(), containerView, viewer, diagramPreferencesHint, location, new SemanticAdapter((EObject)association, null));
        command.add((Command)new ICommandProxy((ICommand)nodeCreation));
        Iterator iteratorProp = endToDisplay.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            ++index;
            EditPart sourceEditPart = null;
            Property currentEnd = (Property)iteratorProp.next();
            Collection editPartSet = viewer.getEditPartRegistry().values();
            Iterator editPartIterator = editPartSet.iterator();
            while (editPartIterator.hasNext() && sourceEditPart == null) {
                EditPart currentEditPart = (EditPart)editPartIterator.next();
                if (currentEditPart instanceof CompartmentEditPart || !(currentEditPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) || !currentEnd.getType().equals(((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
                sourceEditPart = currentEditPart;
            }
            CreateConnectionViewRequest.ConnectionViewDescriptor viewBranchDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Association_4019, ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), diagramPreferencesHint);
            if (sourceEditPart != null) {
                GraphicalAssociationBranchViewCommand aBranchCommand = new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewBranchDescriptor, currentEnd);
                aBranchCommand.setElement((EObject)association);
                command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
                continue;
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)currentEnd.getType());
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, null, -1, false, diagramPreferencesHint);
            CreateCommand nodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, containerView);
            command.add((Command)new ICommandProxy((ICommand)nodeCreationCommand));
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x + 200, location.y + index * 100));
            command.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            GraphicalAssociationBranchViewCommand aBranchCommand = new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), viewer, diagramPreferencesHint, viewBranchDescriptor, currentEnd);
            aBranchCommand.setElement((EObject)association);
            command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
        }
        return command;
    }

    private Command getAssociationToMultiAssociationCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        command = new CompoundCommand();
        Point sourceLocation = null;
        Point targetLocation = null;
        Point nodeLocation = null;
        NamedElement newSemanticElement = null;
        EReference feature = null;
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        View associationView = null;
        Association association = null;
        View parentView = null;
        Property sourceEnd = null;
        Property targetEnd = null;
        ICommandProxy startcommand = (ICommandProxy)createConnectionViewAndElementRequest.getStartCommand();
        for (ICommand currentCommand : (CompositeCommand)startcommand.getICommand()) {
            if (!(currentCommand instanceof SetConnectionBendpointsCommand)) continue;
            sourceLocation = ((SetConnectionBendpointsCommand)currentCommand).getSourceRefPoint();
            targetLocation = ((SetConnectionBendpointsCommand)currentCommand).getTargetRefPoint();
        }
        if (targetEditPart != null) {
            if (((View)sourceEditPart.getModel()).getElement() != null && ((View)sourceEditPart.getModel()).getElement() instanceof Association) {
                associationView = (View)sourceEditPart.getModel();
                association = (Association)((View)sourceEditPart.getModel()).getElement();
                nodeLocation = sourceLocation;
                newSemanticElement = (NamedElement)((View)targetEditPart.getModel()).getElement();
                feature = UMLPackage.eINSTANCE.getTypedElement_Type();
                sourceEnd = AssociationEndSourceLabelHelper.getInstance().getUMLElement((GraphicalEditPart)sourceEditPart.getChildren().get(0));
                targetEnd = AssociationEndTargetLabelHelper.getInstance().getUMLElement((GraphicalEditPart)sourceEditPart.getChildren().get(1));
            }
            if (((View)targetEditPart.getModel()).getElement() != null && ((View)targetEditPart.getModel()).getElement() instanceof Association) {
                associationView = (View)targetEditPart.getModel();
                association = (Association)((View)targetEditPart.getModel()).getElement();
                nodeLocation = targetLocation;
                newSemanticElement = (NamedElement)((View)sourceEditPart.getModel()).getElement();
                feature = UMLPackage.eINSTANCE.getTypedElement_Type();
                sourceEnd = AssociationEndSourceLabelHelper.getInstance().getUMLElement((GraphicalEditPart)targetEditPart.getChildren().get(0));
                targetEnd = AssociationEndTargetLabelHelper.getInstance().getUMLElement((GraphicalEditPart)targetEditPart.getChildren().get(1));
            }
            if (associationView == null || targetEditPart.getModel() instanceof Edge) {
                return null;
            }
            parentView = (View)associationView.eContainer();
            ArrayList ownedProperty = new ArrayList();
            ownedProperty.addAll(association.getMemberEnds());
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)association);
            if (provider != null) {
                SetRequest setRequest = new SetRequest((EObject)association, (EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_OwnedEnd(), ownedProperty);
                ICommand iCommand = provider.getEditCommand((IEditCommandRequest)setRequest);
                ((CompoundCommand)command).add((Command)new ICommandProxy(iCommand));
            }
            DeleteLinkDuringCreationCommand deleteCommand = new DeleteLinkDuringCreationCommand(this.getEditingDomain(), (Edge)associationView, sourceEditPart.getViewer());
            deleteCommand.setReuseParentTransaction(true);
            ICommandProxy removecommand = new ICommandProxy((ICommand)deleteCommand);
            ((CompoundCommand)command).add((Command)removecommand);
            CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)association, UMLElementTypes.Property_3005, UMLPackage.eINSTANCE.getAssociation_OwnedEnd());
            request.setParameter("type", (Object)newSemanticElement);
            PropertyCommandForAssociation propertyCreateCommand = new PropertyCommandForAssociation(request);
            propertyCreateCommand.setReuseParentTransaction(true);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)propertyCreateCommand));
            View associationViewSource = ((Edge)associationView).getSource();
            View associationViewTarget = ((Edge)associationView).getTarget();
            AssociationDiamonViewCreateCommand nodeCreation = new AssociationDiamonViewCreateCommand(this.getEditingDomain(), parentView, sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), nodeLocation, new SemanticAdapter((EObject)association, null));
            nodeCreation.setReuseParentTransaction(true);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)nodeCreation));
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Association_4019, ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint());
            GraphicalAssociationBranchViewCommand firstBranchCommand = new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, (Object)associationViewSource), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, sourceEnd);
            firstBranchCommand.setElement((EObject)association);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)firstBranchCommand));
            GraphicalAssociationBranchViewCommand secondBranchCommand = new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, (Object)associationViewTarget), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, targetEnd);
            secondBranchCommand.setElement((EObject)association);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)secondBranchCommand));
            GraphicalAssociationBranchViewCommand thirdBranchCommand = null;
            thirdBranchCommand = associationView.equals((View)sourceEditPart.getModel()) ? new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, targetEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, request) : new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, request);
            thirdBranchCommand.setElement((EObject)association);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)thirdBranchCommand));
        }
        return command;
    }

    private Command getBranchAssociationCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        command = new CompoundCommand();
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        if (targetEditPart.getModel() instanceof Edge) {
            return null;
        }
        Association association = null;
        NamedElement newSemanticElement = null;
        if (((View)sourceEditPart.getModel()).getElement() != null && ((View)sourceEditPart.getModel()).getElement() instanceof Association) {
            association = (Association)((View)sourceEditPart.getModel()).getElement();
            newSemanticElement = (NamedElement)((View)targetEditPart.getModel()).getElement();
        }
        if (((View)targetEditPart.getModel()).getElement() != null && ((View)targetEditPart.getModel()).getElement() instanceof Association) {
            association = (Association)((View)targetEditPart.getModel()).getElement();
            newSemanticElement = (NamedElement)((View)sourceEditPart.getModel()).getElement();
        }
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)association, UMLElementTypes.Property_3005, UMLPackage.eINSTANCE.getAssociation_OwnedEnd());
        request.setParameter("type", (Object)newSemanticElement);
        PropertyCommandForAssociation propertyCreateCommand = new PropertyCommandForAssociation(request);
        ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)propertyCreateCommand));
        CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Association_4019, ((IHintedType)UMLElementTypes.Association_4019).getSemanticHint(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint());
        GraphicalAssociationBranchViewCommand aBranchCommand = new GraphicalAssociationBranchViewCommand(this.getEditingDomain(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), (IAdaptable)new SemanticAdapter(null, targetEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, request);
        aBranchCommand.setElement((EObject)association);
        ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)aBranchCommand));
        return command;
    }

    public Command getCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        command = new CompoundCommand();
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        if (((View)sourceEditPart.getModel()).getType() == "2015") {
            return this.getBranchAssociationCommand(createConnectionViewAndElementRequest, command);
        }
        if (((View)targetEditPart.getModel()).getType() == "2015") {
            return UnexecutableCommand.INSTANCE;
        }
        if (sourceEditPart instanceof AssociationBranchEditPart) {
            org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart associationNodeEditPart = this.lookForAssociationNodeEditPart((AssociationBranchEditPart)sourceEditPart);
            if (associationNodeEditPart != null) {
                createConnectionViewAndElementRequest.setSourceEditPart((EditPart)associationNodeEditPart);
                return this.getBranchAssociationCommand(createConnectionViewAndElementRequest, command);
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (targetEditPart instanceof AssociationBranchEditPart) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getAssociationToMultiAssociationCommand(createConnectionViewAndElementRequest, command);
    }

    protected org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart lookForAssociationNodeEditPart(AssociationBranchEditPart associationBranchEditPart) {
        if (associationBranchEditPart.getSource() instanceof AssociationNodeEditPart) {
            return (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)associationBranchEditPart.getSource();
        }
        if (associationBranchEditPart.getTarget() instanceof AssociationNodeEditPart) {
            return (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)associationBranchEditPart.getTarget();
        }
        return null;
    }
}

