/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.policies;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.common.editpolicies.ListenerEventEditPolicy;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;

public abstract class AbstractNestedClassifierListenerEditPolicy
extends ListenerEventEditPolicy {
    public static String EDIT_POLICY_ID = "NESTED_CLASSIFIER_LISTENER_EDITPOLICY";
    protected static final String MOVE_CLASSIFIER_TO_NESTED_CLASSIFIER_COMPARTMENT = "Move classifier to NestedClassifier Compartment";
    protected static final String REMOVE_ORPHAN_CLASSIFIER = "Remove Orphan Classifier";

    public void activate() {
        super.activate();
        this.validateNestedClassifier();
    }

    private void validateNestedClassifier() {
        try {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)this.getHost();
            EObject element = graphicalEditPart.resolveSemanticElement();
            for (EStructuralFeature feature : this.getEStructuralFeaturesToListen()) {
                Object values = element.eGet(feature);
                if (!(values instanceof Collection)) continue;
                final Collection valuesFeature = (Collection)values;
                Iterable objectToView = Iterables.transform((Iterable)graphicalEditPart.getNotationView().getChildren(), (Function)new Function<Object, View>(){

                    public View apply(Object from) {
                        if (from instanceof View) {
                            return (View)from;
                        }
                        return null;
                    }
                });
                Iterable viewToDelete = Iterables.filter((Iterable)objectToView, (Predicate)new Predicate<View>(){

                    public boolean apply(View input) {
                        if (input != null) {
                            return !valuesFeature.contains(input.getElement());
                        }
                        return false;
                    }
                });
                CompositeCommand cc = new CompositeCommand("Delete nested class view for old nested classifier");
                for (final View v : viewToDelete) {
                    AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(graphicalEditPart.getEditingDomain(), cc.getLabel(), null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            if (v != null) {
                                ViewUtil.destroy((View)v);
                                return CommandResult.newOKCommandResult();
                            }
                            return CommandResult.newErrorCommandResult((String)"The view to delete is equal to null");
                        }
                    };
                    if (cmd == null || !cmd.canExecute()) continue;
                    cc.compose((IUndoableOperation)cmd);
                }
                this.executeCommand((Command)new ICommandProxy(cc.reduce()));
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("AbstractNestedClassifierListenerEditPolicy should be installed on a IGraphicalEditPart which refer to an EncapsulatedClassifier element");
        }
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeCommand", (Throwable)e);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
        }
    }

    protected ICommand getCommandForListenEvent(EObject newObject, EObject oldObject, EStructuralFeature feature, int eventType, EObject notifier) {
        ICommand result = null;
        switch (eventType) {
            case 3: {
                result = this.handleAddClassifier(newObject);
                break;
            }
            case 4: {
                result = this.handleRemoveClassifier(oldObject);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected ICommand handleRemoveClassifier(EObject oldObject) {
        EObject oldEObject = oldObject;
        Iterable children = DiagramEditPartsUtil.getChildrenByEObject((EObject)oldEObject, (IGraphicalEditPart)this.host(), (boolean)false);
        CompositeCommand cc = new CompositeCommand(REMOVE_ORPHAN_CLASSIFIER);
        for (IGraphicalEditPart child : children) {
            DeleteCommand cmd;
            Object model = child.getModel();
            if (!(model instanceof View) || (cmd = new DeleteCommand((View)model)) == null || !cmd.canExecute()) continue;
            cc.compose((IUndoableOperation)cmd);
        }
        return cc.reduce();
    }

    protected ICommand handleAddClassifier(EObject newObject) {
        CompositeCommand cc = new CompositeCommand(MOVE_CLASSIFIER_TO_NESTED_CLASSIFIER_COMPARTMENT);
        CreateViewRequest.ViewDescriptor viewDescriptor = this.getViewDescriptor(newObject);
        Iterable deleteCommands = Iterables.transform((Iterable)DiagramEditPartsUtil.findViews((EObject)newObject, (EditPartViewer)this.getHost().getViewer()), (Function)new Function<View, ICommand>(){

            public ICommand apply(View from) {
                return new DeleteCommand(from);
            }
        });
        for (ICommand command : deleteCommands) {
            if (command == null || !command.canExecute()) continue;
            cc.compose((IUndoableOperation)command);
        }
        CreateViewRequest request = new CreateViewRequest(viewDescriptor);
        Command cmd = this.getHost().getCommand((Request)request);
        if (cmd != null && cmd.canExecute()) {
            cc.compose((IUndoableOperation)new CommandProxy(cmd));
        }
        return cc.reduce();
    }

    public boolean handleNotificationType(int type) {
        return 3 == type || 4 == type;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element) {
        String factoryHint = this.getDefaultFactoryHint();
        ListenerEventEditPolicy.ElementListenerAdapter elementAdapter = new ListenerEventEditPolicy.ElementListenerAdapter(element, factoryHint);
        int pos = this.getViewIndexFor(element);
        int childHint = UMLVisualIDRegistry.getNodeVisualID((View)this.host().getModel(), element);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, String.valueOf(childHint), pos);
        return descriptor;
    }
}

