/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.policies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.umlutils.InstanceSpecificationUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceSpecificationNameLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    protected final Map<Integer, String> masks = new HashMap<Integer, String>(7);

    public InstanceSpecificationNameLabelEditPolicy() {
        this.masks.put(8, "Name");
        this.masks.put(16, "Type");
    }

    protected void addAdditionalListeners() {
        super.addAdditionalListeners();
        for (Classifier type : this.getUMLElement().getClassifiers()) {
            this.getDiagramEventBroker().addNotificationListener((EObject)type, (NotificationListener)this);
        }
    }

    public void deactivate() {
        if (this.getUMLElement() != null) {
            for (Classifier type : this.getUMLElement().getClassifiers()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)type, (NotificationListener)this);
            }
        }
        super.deactivate();
    }

    public String getMaskLabel(int value) {
        return this.masks.get(value);
    }

    public InstanceSpecification getUMLElement() {
        return (InstanceSpecification)super.getUMLElement();
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Collection<Integer> getMaskValues() {
        return this.masks.keySet();
    }

    public Map<Integer, String> getMasks() {
        return this.masks;
    }

    public int getCurrentDisplayValue() {
        EAnnotation instanceDisplay = ((View)this.getHost().getModel()).getEAnnotation("CustomAppearance_Annotation");
        int displayValue = this.getDefaultDisplayValue();
        if (instanceDisplay != null) {
            displayValue = Integer.parseInt((String)instanceDisplay.getDetails().get((Object)"CustomAppearance_MaskValue"));
        } else {
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            int displayValueTemp = store.getInt("InstanceSpecification.label.display");
            if (displayValueTemp != 0) {
                displayValue = displayValueTemp;
            }
        }
        return displayValue;
    }

    public int getDefaultDisplayValue() {
        return 24;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        InstanceSpecification instance = this.getUMLElement();
        if (notification.getEventType() == 3 && notification.getFeature().equals(UMLPackage.eINSTANCE.getInstanceSpecification_Classifier())) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
        }
        if (notification.getEventType() == 4 && notification.getFeature().equals(UMLPackage.eINSTANCE.getInstanceSpecification_Classifier())) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
        }
        if (object == null) {
            return;
        }
        if (notification.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
            this.refreshDisplay();
        } else if (notification.getFeature().equals(UMLPackage.eINSTANCE.getInstanceSpecification_Classifier())) {
            this.refreshDisplay();
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    public String getPreferencePageID() {
        return "org.eclipse.papyrus.diagram.clazz.custom.preferences.InstanceSpecificationPreferencePage";
    }

    public void refreshDisplay() {
        if (this.getUMLElement() != null) {
            ((WrappingLabel)((GraphicalEditPart)this.getHost()).getFigure()).setText(InstanceSpecificationUtil.getCustomLabel((InstanceSpecification)this.getUMLElement(), (int)this.getCurrentDisplayValue()));
            ((WrappingLabel)((GraphicalEditPart)this.getHost()).getFigure()).setTextUnderline(true);
        }
    }
}

