/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.PropertyLabelHelper;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        Property property = this.getUMLElement();
        if (property == null) {
            Activator.log.error("No semantic element present when adding listeners in PropertyLabelEditPolicy", null);
            return;
        }
        if (property.getType() != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)property.getType(), (NotificationListener)this);
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)property.getUpperValue(), (NotificationListener)this);
        this.getDiagramEventBroker().addNotificationListener((EObject)property.getLowerValue(), (NotificationListener)this);
    }

    public int getCurrentDisplayValue() {
        EAnnotation propertyDisplay = ((View)this.getHost().getModel()).getEAnnotation("CustomAppearance_Annotation");
        int displayValue = this.getDefaultDisplayValue();
        if (propertyDisplay != null) {
            displayValue = Integer.parseInt((String)propertyDisplay.getDetails().get((Object)"CustomAppearance_MaskValue"));
        } else {
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            int displayValueTemp = store.getInt("Property.label.display");
            if (displayValueTemp != 0) {
                displayValue = displayValueTemp;
            }
        }
        return displayValue;
    }

    public int getDefaultDisplayValue() {
        return 62;
    }

    public String getMaskLabel(int value) {
        return PropertyLabelHelper.getInstance().getMaskLabel(value);
    }

    public Collection<String> getMaskLabels() {
        return PropertyLabelHelper.getInstance().getMaskLabels();
    }

    public Map<Integer, String> getMasks() {
        return PropertyLabelHelper.getInstance().getMasks();
    }

    public Collection<Integer> getMaskValues() {
        return PropertyLabelHelper.getInstance().getMaskValues();
    }

    public String getPreferencePageID() {
        return "org.eclipse.papyrus.diagram.clazz.custom.preferences.PropertyPreferencePage";
    }

    public Property getUMLElement() {
        return (Property)super.getUMLElement();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Property property = this.getUMLElement();
        if (object == null || property == null) {
            return;
        }
        if (notification.getFeature().equals(UMLPackage.eINSTANCE.getLiteralInteger_Value())) {
            this.refreshDisplay();
        } else if (notification.getFeature().equals(UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value())) {
            this.refreshDisplay();
        }
        if (object.equals(property)) {
            this.notifyPropertyChanged(property, notification);
        } else if (object.equals(property.getType())) {
            this.notifyPropertyTypeChanged(property.getType(), notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected void notifyPropertyChanged(Property property, Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 22: 
            case 30: 
            case 35: 
            case 37: 
            case 39: {
                this.refreshDisplay();
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyPropertyTypeChanged(Type type, Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 4: {
                this.refreshDisplay();
                break;
            }
        }
    }

    public void refreshDisplay() {
        PropertyLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)this.getHost());
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Property property = this.getUMLElement();
        if (property == null) {
            return;
        }
        if (property.getType() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)property.getType(), (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)property.getUpperValue(), (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener((EObject)property.getLowerValue(), (NotificationListener)this);
    }
}

