/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.policies.itemsemantic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyReferenceCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.clazz.custom.command.CustomReorientContainmentLinkCommand;
import org.eclipse.papyrus.diagram.clazz.custom.edit.part.CContainmentCircleEditPart;
import org.eclipse.papyrus.diagram.clazz.custom.helper.ContainmentHelper;
import org.eclipse.papyrus.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.ui.toolbox.notification.popups.PopupNotification;
import org.eclipse.uml2.uml.NamedElement;

public class CustomContainmentCircleItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public CustomContainmentCircleItemSemanticEditPolicy() {
        super(UMLElementTypes.Node_3032);
    }

    protected Command getDestroyElementCommandGen(DestroyElementRequest req) {
        DestroyElementRequest r;
        View view = (View)this.getHost().getModel();
        CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(this.getEditingDomain(), null);
        cmd.setTransactionNestingEnabled(false);
        for (Edge incomingLink : view.getTargetEdges()) {
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4005) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4006) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4007) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4008) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4018) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4013) {
                r = new DestroyReferenceRequest(incomingLink.getSource().getElement(), null, incomingLink.getTarget().getElement(), false);
                cmd.add((IUndoableOperation)new DestroyReferenceCommand((DestroyReferenceRequest)r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4014) {
                r = new DestroyReferenceRequest(incomingLink.getSource().getElement(), null, incomingLink.getTarget().getElement(), false);
                cmd.add((IUndoableOperation)new DestroyReferenceCommand((DestroyReferenceRequest)r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4015) {
                r = new DestroyElementRequest(incomingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) == 4024) {
                r = new DestroyReferenceRequest(incomingLink.getSource().getElement(), null, incomingLink.getTarget().getElement(), false);
                cmd.add((IUndoableOperation)new DestroyReferenceCommand((DestroyReferenceRequest)r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)incomingLink) != 4025) continue;
            r = new DestroyReferenceRequest(incomingLink.getSource().getElement(), null, incomingLink.getTarget().getElement(), false);
            cmd.add((IUndoableOperation)new DestroyReferenceCommand((DestroyReferenceRequest)r));
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
        }
        for (Edge outgoingLink : view.getSourceEdges()) {
            if (UMLVisualIDRegistry.getVisualID((View)outgoingLink) == 4005) {
                r = new DestroyElementRequest(outgoingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)outgoingLink) == 4006) {
                r = new DestroyElementRequest(outgoingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)outgoingLink) == 4007) {
                r = new DestroyElementRequest(outgoingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)outgoingLink) == 4008) {
                r = new DestroyElementRequest(outgoingLink.getElement(), false);
                cmd.add((IUndoableOperation)new DestroyElementCommand(r));
                cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID((View)outgoingLink) != 4018) continue;
            r = new DestroyElementRequest(outgoingLink.getElement(), false);
            cmd.add((IUndoableOperation)new DestroyElementCommand(r));
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
        }
        EAnnotation annotation = view.getEAnnotation("Shortcut");
        if (annotation == null) {
            this.addDestroyShortcutsCommand((ICompositeCommand)cmd, view);
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), view));
        } else {
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), view));
        }
        return this.getGEFWrapper(cmd.reduce());
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(this.getEditingDomain(), null);
        View circle = (View)this.getHost().getModel();
        ArrayList<String> targetNames = new ArrayList<String>();
        for (Object next : circle.getSourceEdges()) {
            Edge outgoingLink = (Edge)next;
            if (!ContainmentHelper.isContainmentLink(outgoingLink)) continue;
            targetNames.add(((NamedElement)outgoingLink.getTarget().getElement()).getName());
        }
        cmd.add((IUndoableOperation)new AskToDeleteContainmentCommand(targetNames));
        ICommandProxy command = (ICommandProxy)this.getDestroyElementCommandGen(req);
        cmd.add((IUndoableOperation)command.getICommand());
        for (Object next : circle.getSourceEdges()) {
            Edge outgoingLink = (Edge)next;
            if (!ContainmentHelper.isContainmentLink(outgoingLink)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), outgoingLink.getTarget()));
            cmd.add((IUndoableOperation)new DestroyElementCommand(new DestroyElementRequest(outgoingLink.getTarget().getElement(), true)));
            ContainmentHelper.addDeleteOutgoingContainmentLinkViewCommands(this.getEditingDomain(), outgoingLink.getTarget(), (ICompositeCommand)cmd);
        }
        return this.getGEFWrapper(cmd.reduce());
    }

    public Command getCommand(Request request) {
        if (request instanceof ReconnectRequest && ((ReconnectRequest)request).getTarget() instanceof CContainmentCircleEditPart) {
            return this.getCustomReconnectRequest((ReconnectRequest)request);
        }
        return super.getCommand(request);
    }

    public Command getCustomReconnectRequest(ReconnectRequest request) {
        CompoundCommand cc = new CompoundCommand();
        cc.add((Command)new ICommandProxy((ICommand)new CustomReorientContainmentLinkCommand(this.getEditingDomain(), (Request)request)));
        return cc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AskToDeleteContainmentCommand
    extends AbstractOperation {
        private List<String> myTargetNames;

        public AskToDeleteContainmentCommand(List<String> targetNames) {
            super("Show Question Dialog");
            this.myTargetNames = targetNames;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            String messageFormat = "You are about to delete a Containment Link - %s and its contained elements will be deleted as well. Are you sure you want to delete it?";
            String message = String.format(messageFormat, this.getNamesString());
            NotificationBuilder builder = NotificationBuilder.createYesNo((String)message);
            int dialogResult = ((PopupNotification)builder.run()).getResult();
            if (dialogResult == 64) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        private String getNamesString() {
            String namesString = "";
            Iterator<String> namesIterator = this.myTargetNames.iterator();
            while (namesIterator.hasNext()) {
                namesString = String.valueOf(namesString) + "'" + namesIterator.next() + "'";
                if (!namesIterator.hasNext()) continue;
                namesString = String.valueOf(namesString) + ", ";
            }
            return namesString;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }
}

