/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.custom.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizationUtil {
    public boolean isConcernedByGeneralizationChanges(Generalization generalization, View view) {
        boolean isConcerned = false;
        NamedElement graphicalOwner = this.getGraphicalOwner(view);
        if ((Element)view.getElement().eContainer() != graphicalOwner) {
            Type type;
            if (graphicalOwner instanceof Classifier) {
                if (graphicalOwner != null && generalization != null) {
                    isConcerned = this.getAllGeneralization((Classifier)graphicalOwner, null).contains(generalization);
                }
            } else if (graphicalOwner instanceof Property && (type = ((Property)graphicalOwner).getType()) instanceof Classifier) {
                isConcerned = this.getAllGeneralization((Classifier)type, null).contains(generalization);
            }
            if (isConcerned && this.existsAnotherInheritanceWay((Element)view.getElement(), generalization, graphicalOwner, null)) {
                isConcerned = false;
            }
        }
        return isConcerned;
    }

    protected boolean existsAnotherInheritanceWay(Element inheritedElement, Generalization forbiddenPath, NamedElement el, Set<Element> ignoredGeneralizations) {
        HashSet generalizations = new HashSet();
        Classifier _classifier = null;
        if (el instanceof Property) {
            Type type = ((Property)el).getType();
            if (type instanceof Classifier) {
                _classifier = (Classifier)type;
            }
        } else if (el instanceof Classifier) {
            _classifier = (Classifier)el;
        }
        HashSet<Element> ignoredGeneralizationsTmp = new HashSet<Element>();
        if (ignoredGeneralizations != null) {
            ignoredGeneralizationsTmp.addAll(ignoredGeneralizations);
        }
        if (el != null) {
            generalizations.addAll(_classifier.getGeneralizations());
            for (Generalization generalization : generalizations) {
                Classifier general;
                if (generalization == forbiddenPath || ignoredGeneralizationsTmp.contains(generalization) || (general = generalization.getGeneral()) == null) continue;
                ignoredGeneralizationsTmp.add((Element)generalization);
                if (general.getOwnedMembers().contains((Object)inheritedElement)) {
                    return true;
                }
                if (!this.existsAnotherInheritanceWay(inheritedElement, forbiddenPath, (NamedElement)general, ignoredGeneralizationsTmp)) continue;
                return true;
            }
        }
        return false;
    }

    protected NamedElement getGraphicalOwner(View view) {
        EObject graphicalParent;
        if (view.eContainer() instanceof View && ((graphicalParent = ((View)view.eContainer()).getElement()) instanceof Classifier || graphicalParent instanceof Property)) {
            return (NamedElement)graphicalParent;
        }
        return null;
    }

    protected Set<Generalization> getAllGeneralization(Classifier classifier, Set<Classifier> alreadyParsedClassifiers) {
        HashSet<Generalization> generalizations = new HashSet<Generalization>();
        HashSet<Classifier> parsedClassifiers = new HashSet<Classifier>();
        if (alreadyParsedClassifiers != null) {
            parsedClassifiers.addAll(alreadyParsedClassifiers);
        }
        HashSet<Generalization> generalizationsTmp = new HashSet<Generalization>();
        if (classifier != null) {
            generalizations.addAll((Collection<Generalization>)classifier.getGeneralizations());
            if (!parsedClassifiers.contains(classifier)) {
                parsedClassifiers.add(classifier);
                for (Generalization generalization : generalizations) {
                    generalizationsTmp.addAll(this.getAllGeneralization(generalization.getGeneral(), parsedClassifiers));
                }
            }
        }
        generalizations.addAll(generalizationsTmp);
        return generalizations;
    }
}

