/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ProfileApplicationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ProfileApplication)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Package) || !(this.newEnd instanceof Package)) {
            return false;
        }
        Profile target = this.getLink().getAppliedProfile();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistProfileApplication_4012(this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Profile) || !(this.newEnd instanceof Profile)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package source = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistProfileApplication_4012(this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getProfileApplications().remove((Object)this.getLink());
        this.getNewSource().getProfileApplications().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setAppliedProfile(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ProfileApplication getLink() {
        return (ProfileApplication)this.getElementToEdit();
    }

    protected Package getOldSource() {
        return (Package)this.oldEnd;
    }

    protected Package getNewSource() {
        return (Package)this.newEnd;
    }

    protected Profile getOldTarget() {
        return (Profile)this.oldEnd;
    }

    protected Profile getNewTarget() {
        return (Profile)this.newEnd;
    }
}

