/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.diagram.common.groups.core.utils.Utils;
import org.eclipse.papyrus.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateReferencesCommand
extends AbstractTransactionalCommand {
    public static final boolean SET_MODE = true;
    public static final boolean UNSET_MODE = false;
    private List<IGraphicalEditPart> childrenPart;
    private AbstractContainerNodeDescriptor descriptor;
    private IAdaptable elementAdapter;
    private boolean setMode = true;

    public UpdateReferencesCommand(TransactionalEditingDomain domain, String label, List<IGraphicalEditPart> children, AbstractContainerNodeDescriptor descriptor, IAdaptable adapter) {
        super(domain, label, null);
        this.descriptor = descriptor;
        this.elementAdapter = adapter;
        this.childrenPart = children;
    }

    public UpdateReferencesCommand(TransactionalEditingDomain domain, String label, List<IGraphicalEditPart> children, AbstractContainerNodeDescriptor descriptor, IAdaptable adapter, boolean mode) {
        super(domain, label, null);
        this.descriptor = descriptor;
        this.elementAdapter = adapter;
        this.childrenPart = children;
        this.setMode = mode;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        Object createdElement = this.elementAdapter.getAdapter(EObject.class);
        if (createdElement instanceof EObject) {
            EObject eObjectCreatedElement = (EObject)createdElement;
            for (IGraphicalEditPart part : this.childrenPart) {
                EObject childElement = part.resolveSemanticElement();
                if (this.descriptor == null) continue;
                List<EReference> refs = this.descriptor.getReferenceFor(childElement.eClass());
                for (EReference ref : refs) {
                    if (ref != null && ref.isMany()) {
                        Collection collection = (Collection)eObjectCreatedElement.eGet((EStructuralFeature)ref);
                        if (this.setMode) {
                            if (collection.contains(childElement)) continue;
                            collection.add(childElement);
                            continue;
                        }
                        if (!collection.contains(childElement)) continue;
                        collection.remove(childElement);
                        continue;
                    }
                    if (ref == null || ref.isMany()) continue;
                    if (this.setMode) {
                        eObjectCreatedElement.eSet((EStructuralFeature)ref, (Object)childElement);
                        continue;
                    }
                    eObjectCreatedElement.eUnset((EStructuralFeature)ref);
                }
                Utils.withDrawRedundantElementReferenced(childElement);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

