/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.core;

import org.eclipse.emf.common.command.Command;
import org.eclipse.papyrus.diagram.common.groups.core.ui.CompositeCreatorWithCommand;
import org.eclipse.papyrus.ui.toolbox.notification.Type;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;

public class GroupNotificationBuilderFactory {
    public static NotificationBuilder getQuestionBuilder(String label) {
        NotificationBuilder builder = NotificationBuilder.createInformationBuilder();
        builder.setType(Type.QUESTION);
        builder.setTemporary(true);
        builder.setAsynchronous(true);
        builder.setTitle(label);
        return builder;
    }

    public static NotificationBuilder getWarningBuilder(String label) {
        NotificationBuilder builder = NotificationBuilder.createInformationBuilder();
        builder.setType(Type.WARNING);
        builder.setTemporary(true);
        builder.setAsynchronous(true);
        builder.setTitle(label);
        return builder;
    }

    public static class NotificationBuilderAndResultingCommand {
        private NotificationBuilder builder;
        private CompositeCreatorWithCommand creator;

        public NotificationBuilderAndResultingCommand(NotificationBuilder notificationBuilder, CompositeCreatorWithCommand creatorWithCommand) {
            this.builder = notificationBuilder;
            this.creator = creatorWithCommand;
        }

        public NotificationBuilder getBuilder() {
            return this.builder;
        }

        public Command getResultingCommand() {
            return this.creator.getResultingCommand();
        }

        public CompositeCreatorWithCommand getCreator() {
            return this.creator;
        }
    }
}

