/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.diagram.common.groups.core.ui.ChooseChildrenNotificationConfigurator;
import org.eclipse.papyrus.diagram.common.groups.core.ui.ChooseParentNotificationConfigurator;
import org.eclipse.papyrus.diagram.common.groups.core.ui.NotificationConfigurator;

public class PendingGroupNotificationsManager {
    private static Map<DiagramEditPart, PendingGroupNotificationsManager> instances = new HashMap<DiagramEditPart, PendingGroupNotificationsManager>();
    private DiagramEditPart diagramEditPart = null;
    private Map<IGraphicalEditPart, NotificationConfigurator> chooseParentNotifications = new HashMap<IGraphicalEditPart, NotificationConfigurator>();
    private HashMap<IGraphicalEditPart, NotificationConfigurator> chooseChildrenNotifications = new HashMap();

    private PendingGroupNotificationsManager(DiagramEditPart diagramPart) {
        this.diagramEditPart = diagramPart;
    }

    public void delete() {
        this.chooseParentNotifications.clear();
        this.chooseChildrenNotifications.clear();
        instances.remove(this.diagramEditPart);
        this.diagramEditPart = null;
    }

    public static PendingGroupNotificationsManager getInstanceForDiagram(DiagramEditPart diagramPart) {
        if (diagramPart.isActive()) {
            if (!instances.containsKey(diagramPart)) {
                PendingGroupNotificationsManager instance = new PendingGroupNotificationsManager(diagramPart);
                instances.put(diagramPart, instance);
                return instance;
            }
            return instances.get(diagramPart);
        }
        return null;
    }

    public static void removeInstanceForDiagram(DiagramEditPart diagramPart) {
        if (instances.containsKey(diagramPart)) {
            instances.get(diagramPart).delete();
        }
    }

    public void removeChooseParentNotification(IGraphicalEditPart childEditPart) {
        this.chooseParentNotifications.remove(childEditPart);
    }

    public void removeChooseChildrenNotification(IGraphicalEditPart parentGroup) {
        this.chooseChildrenNotifications.remove(parentGroup);
    }

    public void storeNotification(NotificationConfigurator configurator) {
        if (configurator instanceof ChooseParentNotificationConfigurator) {
            this.chooseParentNotifications.put(((ChooseParentNotificationConfigurator)configurator).getMainEditPart(), configurator);
        } else if (configurator instanceof ChooseChildrenNotificationConfigurator) {
            this.chooseChildrenNotifications.put(((ChooseChildrenNotificationConfigurator)configurator).getMainEditPart(), configurator);
        }
    }

    public NotificationConfigurator getChooseChildrenPendingNotification(IGraphicalEditPart parentEditPart) {
        if (this.chooseChildrenNotifications.containsKey(parentEditPart)) {
            return this.chooseChildrenNotifications.get(parentEditPart);
        }
        return null;
    }
}

