/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.core.ui;

import java.util.ArrayList;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.diagram.common.groups.core.GroupNotificationBuilderFactory;
import org.eclipse.papyrus.diagram.common.groups.core.PendingGroupNotificationsManager;
import org.eclipse.papyrus.ui.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.ui.toolbox.notification.INotification;
import org.eclipse.papyrus.ui.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.ui.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.ui.toolbox.notification.view.AbstractInsideComposite;
import org.eclipse.papyrus.ui.toolbox.notification.view.PapyrusNotificationView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class NotificationConfigurator
implements ICompositeCreator,
NotificationRunnable {
    protected PendingGroupNotificationsManager manager;
    protected NotificationBuilder notificationBuilder;
    protected INotification notification;
    protected AbstractInsideComposite papyrusNotificationView;
    protected IGraphicalEditPart mainEditPart;
    private String label;

    public NotificationConfigurator(IGraphicalEditPart _mainEdipart, PendingGroupNotificationsManager _manager, String _label, Mode mode) {
        this.mainEditPart = _mainEdipart;
        this.manager = _manager;
        this.label = _label;
        switch (mode) {
            case WARNING_MODE: {
                this.notificationBuilder = GroupNotificationBuilderFactory.getWarningBuilder(_label);
                break;
            }
            default: {
                this.notificationBuilder = GroupNotificationBuilderFactory.getQuestionBuilder(_label);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setMainEditPart(IGraphicalEditPart mainEditPart) {
        this.mainEditPart = mainEditPart;
    }

    public INotification runConfigurator() {
        this.notification = this.notificationBuilder.setComposite((ICompositeCreator)this).addAction((NotificationRunnable)this).run();
        if (this.notification != null) {
            if (this.manager != null) {
                this.manager.storeNotification(this);
            }
            try {
                IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.ui.toolbox.notification.view.PapyrusNotificationView");
                if (part instanceof PapyrusNotificationView) {
                    AbstractInsideComposite viewCompo;
                    PapyrusNotificationView view = (PapyrusNotificationView)part;
                    ArrayList<NotificationConfigurator> singleton = new ArrayList<NotificationConfigurator>(1);
                    singleton.add(this);
                    this.papyrusNotificationView = viewCompo = view.setComposite((ICompositeCreator)this, this.getLabel(), singleton);
                    viewCompo.setINotification(this.notification);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return this.notification;
    }

    public INotification getNotification() {
        return this.notification;
    }

    protected abstract void closeNotitfication(IContext var1);

    public void closeNotification() {
        this.closeNotitfication(null);
    }

    public IGraphicalEditPart getMainEditPart() {
        return this.mainEditPart;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        QUESTION_MODE,
        WARNING_MODE;

    }
}

