/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.diagram.common.groups.Activator;
import org.eclipse.papyrus.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.diagram.common.groups.core.utils.DefaultModelParent;
import org.eclipse.papyrus.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;
import org.eclipse.papyrus.diagram.common.groups.utils.GraphicalAndModelElementComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static List<IGraphicalEditPart> findPossibleParents(Rectangle bounds, DiagramEditPart diagramPart) {
        if (diagramPart == null) {
            return Collections.emptyList();
        }
        HashSet<IGraphicalEditPart> groupParts = new HashSet<IGraphicalEditPart>();
        for (Object view : diagramPart.getViewer().getEditPartRegistry().keySet()) {
            AbstractContainerNodeDescriptor desc;
            IGraphicalEditPart part;
            Object editpart;
            if (!(view instanceof View) || !((editpart = diagramPart.getViewer().getEditPartRegistry().get(view)) instanceof IGraphicalEditPart) || !GroupContainmentRegistry.isContainerConcerned(part = (IGraphicalEditPart)editpart) || !(desc = GroupContainmentRegistry.getContainerDescriptor(part)).getContentArea(part).contains(bounds)) continue;
            groupParts.add(part);
        }
        return new ArrayList<IGraphicalEditPart>(groupParts);
    }

    public static boolean createComputedListsOfParents(List<IGraphicalEditPart> graphicalParentsToComplete, List<IGraphicalEditPart> modelParentsToComplete, IGraphicalEditPart childPart, ChangeBoundsRequest request, boolean doTransalte) {
        ArrayList<View> diagramViews = new ArrayList<View>(childPart.getViewer().getEditPartRegistry().keySet());
        Object _elementView = childPart.getModel();
        if (_elementView instanceof View) {
            diagramViews.remove(_elementView);
            View myGroupView = (View)_elementView;
            Utils.withdrawGraphicalSonsOf(diagramViews, myGroupView);
        }
        Rectangle bounds = null;
        EClass childType = null;
        bounds = Utils.getAbsoluteBounds(childPart).getCopy();
        childType = childPart.resolveSemanticElement().eClass();
        if (doTransalte) {
            bounds = request.getTransformedRectangle(bounds);
        }
        return Utils.createComputedListsOfParents(graphicalParentsToComplete, modelParentsToComplete, bounds, childType, diagramViews, childPart);
    }

    public static boolean createComputedListsOfParents(List<IGraphicalEditPart> graphicalParentsToComplete, List<IGraphicalEditPart> modelParentsToComplete, CreateViewAndElementRequest creationRequest, IGraphicalEditPart anyPart, EClass child) {
        ArrayList<View> diagramViews = new ArrayList<View>(anyPart.getViewer().getEditPartRegistry().keySet());
        Dimension size = creationRequest.getSize();
        if (size == null || size.isEmpty()) {
            size = new Dimension(0, 0);
        }
        Rectangle bounds = new Rectangle(creationRequest.getLocation(), size);
        return Utils.createComputedListsOfParents(graphicalParentsToComplete, modelParentsToComplete, bounds, child, diagramViews, anyPart);
    }

    private static boolean createComputedListsOfParents(List<IGraphicalEditPart> graphicalParentsToComplete, List<IGraphicalEditPart> modelParentsToComplete, Rectangle bounds, EClass child, Collection<View> views, IGraphicalEditPart anyPart) {
        if (views.isEmpty()) {
            return false;
        }
        for (View view : views) {
            AbstractContainerNodeDescriptor desc;
            IGraphicalEditPart part;
            Object editpart;
            if (!(view instanceof View) || !((editpart = anyPart.getViewer().getEditPartRegistry().get(view)) instanceof IGraphicalEditPart) || !GroupContainmentRegistry.isContainerConcerned(part = (IGraphicalEditPart)editpart) || !(desc = GroupContainmentRegistry.getContainerDescriptor(part)).getContentArea(part).contains(bounds) || !(child instanceof EClass)) continue;
            if (desc.canIBeModelParentOf(child)) {
                graphicalParentsToComplete.add(part);
                modelParentsToComplete.add(part);
                continue;
            }
            if (!desc.canIBeGraphicalParentOf(child)) continue;
            graphicalParentsToComplete.add(part);
        }
        if (graphicalParentsToComplete.size() > 1) {
            Utils.withdrawUselessAncestorsElements(graphicalParentsToComplete, GraphicalAndModelElementComparator.Mode.GRAPHICAL_AND_MODEL);
        }
        if (modelParentsToComplete.size() > 1) {
            Utils.withdrawUselessAncestorsElements(modelParentsToComplete, GraphicalAndModelElementComparator.Mode.MODEL);
        }
        return true;
    }

    public static boolean createComputedListsOfVisualYRelatedElements(List<IGraphicalEditPart> childsToComplete, CreateViewAndElementRequest creationRequest, IGraphicalEditPart anyPart, AbstractContainerNodeDescriptor descriptor) {
        ArrayList<View> diagramViews = new ArrayList<View>(anyPart.getViewer().getEditPartRegistry().keySet());
        Dimension size = creationRequest.getSize();
        if (size == null || size.isEmpty()) {
            size = new Dimension(0, 0);
        }
        Rectangle bounds = new Rectangle(creationRequest.getLocation(), size);
        Utils.createComputedListsOfVisualyRelatedElements(childsToComplete, bounds, descriptor, diagramViews, anyPart);
        return true;
    }

    public static boolean createComputedListsOfVisuallyRelatedElements(List<IGraphicalEditPart> childsToComplete, ChangeBoundsRequest request, IGraphicalEditPart parentPart, AbstractContainerNodeDescriptor descriptor, boolean doTransalte) {
        ArrayList<View> diagramViews = new ArrayList<View>(parentPart.getViewer().getEditPartRegistry().keySet());
        diagramViews.remove(parentPart.getModel());
        Rectangle bounds = null;
        IGraphicalEditPart compartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(parentPart.getViewer().getEditPartRegistry(), (EditPart)parentPart);
        if (compartmentEditPart == null) {
            compartmentEditPart = parentPart;
        }
        bounds = Utils.getAbsoluteBounds(compartmentEditPart).getCopy();
        if (doTransalte) {
            bounds = request.getTransformedRectangle(bounds);
        }
        Utils.createComputedListsOfVisualyRelatedElements(childsToComplete, bounds, descriptor, diagramViews, parentPart);
        return true;
    }

    public static List<IGraphicalEditPart> createComputeListsOfAllGroupContainerVisually(IGraphicalEditPart element, ChangeBoundsRequest request, boolean doTranslate, IGraphicalEditPart movingParent) {
        ArrayList<IGraphicalEditPart> result = new ArrayList<IGraphicalEditPart>();
        EditPartViewer viewer = element.getViewer();
        Map editPartRegistry = null;
        if (viewer != null) {
            editPartRegistry = viewer.getEditPartRegistry();
        }
        if (editPartRegistry == null || element == null) {
            return null;
        }
        IGraphicalEditPart myCompartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(editPartRegistry, (EditPart)element);
        Rectangle myBounds = null;
        myBounds = myCompartmentEditPart != null ? Utils.getAbsoluteBounds(myCompartmentEditPart).getCopy() : Utils.getAbsoluteBounds(element).getCopy();
        if (doTranslate) {
            myBounds = myBounds.translate(request.getMoveDelta());
        }
        ArrayList<View> diagramViews = new ArrayList<View>(editPartRegistry.keySet());
        Object _elementView = element.getModel();
        diagramViews.remove(_elementView);
        if (_elementView instanceof View) {
            View view = (View)_elementView;
            Utils.withdrawGraphicalSonsOf(diagramViews, view);
        }
        for (Object e : diagramViews) {
            Object editpart;
            if (!(e instanceof View) || !((editpart = editPartRegistry.get(e)) instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart part = (IGraphicalEditPart)editpart;
            IGraphicalEditPart partCompartment = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(editPartRegistry, (EditPart)part);
            if (!GroupContainmentRegistry.isContainerConcerned(part) || partCompartment == null) continue;
            Rectangle partBounds = Utils.getAbsoluteBounds(partCompartment);
            if ((part.getParent().equals(movingParent) || partCompartment.equals(movingParent)) && doTranslate) {
                partBounds = request.getTransformedRectangle(partBounds);
            }
            if (!partBounds.contains(myBounds)) continue;
            result.add(part);
        }
        return result;
    }

    private static void withdrawGraphicalSonsOf(Collection<View> views, View myView) {
        for (Object o : myView.getChildren()) {
            if (!(o instanceof View)) continue;
            View childView = (View)o;
            Utils.withdrawGraphicalSonsOf(views, childView);
            views.remove(childView);
        }
    }

    private static boolean createComputedListsOfVisualyRelatedElements(List<IGraphicalEditPart> childsToComplete, Rectangle parentsBounds, AbstractContainerNodeDescriptor descriptor, Collection<View> views, IGraphicalEditPart anyPart) {
        ArrayList<EClass> possibleChildrenEClass = new ArrayList<EClass>(descriptor.getPossibleGraphicalChildren());
        if (!possibleChildrenEClass.isEmpty()) {
            block0: for (View view : views) {
                IGraphicalEditPart part;
                View childView;
                EObject element;
                if (!(view instanceof View) || (element = (childView = view).getElement()) == null) continue;
                EClass childEclass = element.eClass();
                Object editpart = anyPart.getViewer().getEditPartRegistry().get(childView);
                if (!(editpart instanceof IGraphicalEditPart) || !Utils.isMainEditPart(part = (IGraphicalEditPart)editpart)) continue;
                for (EClass possibleChild : possibleChildrenEClass) {
                    if (!possibleChild.isSuperTypeOf(childEclass) || !Utils.isItVisualyContained(parentsBounds, part)) continue;
                    childsToComplete.add(part);
                    continue block0;
                }
            }
            if (childsToComplete.size() > 1) {
                Utils.withdrawUselessDescendantElements(childsToComplete, GraphicalAndModelElementComparator.Mode.GRAPHICAL_AND_MODEL);
            }
        }
        return true;
    }

    private static boolean isItVisualyContained(Rectangle parentBounds, IGraphicalEditPart child) {
        Rectangle bounds;
        return child.getParent() instanceof IGraphicalEditPart && (bounds = Utils.getAbsoluteBounds(child)) != null && parentBounds.contains(bounds);
    }

    public static boolean isMainEditPart(IGraphicalEditPart part) {
        EObject currentElement = part.resolveSemanticElement();
        EditPart parentEditPart = part.getParent();
        if (parentEditPart instanceof IGraphicalEditPart) {
            return !currentElement.equals(((IGraphicalEditPart)parentEditPart).resolveSemanticElement());
        }
        return true;
    }

    private static void withdrawUselessAncestorsElements(List<IGraphicalEditPart> listToModify, GraphicalAndModelElementComparator.Mode mode) {
        if (!listToModify.isEmpty()) {
            GraphicalAndModelElementComparator comparator = new GraphicalAndModelElementComparator(listToModify.get(0));
            comparator.setMode(mode);
            int element = 0;
            while (element < listToModify.size()) {
                int elementToCompare = element + 1;
                while (elementToCompare < listToModify.size()) {
                    int compare = comparator.compare(listToModify.get(element), listToModify.get(elementToCompare));
                    if (compare < 0) {
                        listToModify.remove(element);
                        --element;
                        elementToCompare = listToModify.size();
                    } else if (compare > 0) {
                        listToModify.remove(elementToCompare);
                        --elementToCompare;
                    }
                    ++elementToCompare;
                }
                ++element;
            }
        }
    }

    public static void withDrawRedundantElementReferenced(EObject object) {
        Set<EReference> groupFrameworkReferences = GroupContainmentRegistry.getAllERefencesFromNodeToGroup();
        HashMap<EObject, EReference> referencingGroupsAndTheirRelation = new HashMap<EObject, EReference>();
        HashSet<EObject> elementToVosit = new HashSet<EObject>();
        for (EReference ref : groupFrameworkReferences) {
            if (!object.eClass().getEAllReferences().contains((Object)ref)) continue;
            List<EObject> groups = ref.isMany() ? (List<EObject>)object.eGet((EStructuralFeature)ref) : Collections.singletonList((EObject)object.eGet((EStructuralFeature)ref));
            if (!ref.isContainment()) {
                for (EObject element : groups) {
                    if (referencingGroupsAndTheirRelation.containsKey(element) || ref.isDerived()) continue;
                    referencingGroupsAndTheirRelation.put(element, ref);
                }
            }
            for (EObject group : groups) {
                if (group == null) continue;
                elementToVosit.add(group);
            }
        }
        HashSet<EObject> elementAlreadyVisited = new HashSet<EObject>();
        for (EObject visitingElement : elementToVosit) {
            Utils.withDrawRedundantElementReferenced(object, groupFrameworkReferences, referencingGroupsAndTheirRelation, elementAlreadyVisited, visitingElement);
        }
    }

    private static void withDrawRedundantElementReferenced(EObject originalEObject, Set<EReference> groupFrameworkReferences, Map<EObject, EReference> directlyReferencedByElement, Set<EObject> elementAlreadyVisited, EObject visitingElement) {
        if (visitingElement != null) {
            elementAlreadyVisited.add(visitingElement);
            for (EReference ref : groupFrameworkReferences) {
                if (visitingElement == null || !visitingElement.eClass().getEAllReferences().contains((Object)ref)) continue;
                List<EObject> groups = ref.isMany() ? (List<EObject>)visitingElement.eGet((EStructuralFeature)ref) : Collections.singletonList((EObject)visitingElement.eGet((EStructuralFeature)ref));
                for (EObject currentElementParentGroup : groups) {
                    if (directlyReferencedByElement.containsKey(currentElementParentGroup)) {
                        Utils.withdrawEObjectFromReference(originalEObject, currentElementParentGroup, directlyReferencedByElement.get(currentElementParentGroup));
                        continue;
                    }
                    if (elementAlreadyVisited.contains(currentElementParentGroup)) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.diagram.common.groups", "There is a circle element reference"));
                        continue;
                    }
                    Utils.withDrawRedundantElementReferenced(originalEObject, groupFrameworkReferences, directlyReferencedByElement, elementAlreadyVisited, currentElementParentGroup);
                }
            }
        }
    }

    private static void withdrawEObjectFromReference(EObject source, EObject destination, EReference ref) {
        if (ref != null && source != null && destination != null) {
            if (ref != null && ref.isMany()) {
                Collection collection = (Collection)source.eGet((EStructuralFeature)ref);
                if (collection.contains(destination)) {
                    collection.remove(destination);
                }
            } else if (ref != null && !ref.isMany()) {
                source.eUnset((EStructuralFeature)ref);
            }
        }
    }

    private static boolean withdrawUselessDescendantElements(List<IGraphicalEditPart> listToModify, GraphicalAndModelElementComparator.Mode mode) {
        if (!listToModify.isEmpty()) {
            GraphicalAndModelElementComparator comparator = new GraphicalAndModelElementComparator(listToModify.get(0));
            comparator.setMode(mode);
            int element = 0;
            while (element < listToModify.size()) {
                int elementToCompare = element + 1;
                while (elementToCompare < listToModify.size()) {
                    int compare = comparator.compare(listToModify.get(element), listToModify.get(elementToCompare));
                    if (compare > 0) {
                        listToModify.remove(element);
                        --element;
                        elementToCompare = listToModify.size();
                    } else if (compare < 0) {
                        listToModify.remove(elementToCompare);
                        --elementToCompare;
                    }
                    ++elementToCompare;
                }
                ++element;
            }
        }
        return true;
    }

    public static List<IGraphicalEditPart> findPossibleChildren(Rectangle contentArea, IGraphicalEditPart groupEditPart, DiagramEditPart diagramPart) {
        AbstractContainerNodeDescriptor descriptor = GroupContainmentRegistry.getContainerDescriptor(groupEditPart);
        if (diagramPart == null || descriptor == null) {
            return Collections.emptyList();
        }
        HashSet<IGraphicalEditPart> groupParts = new HashSet<IGraphicalEditPart>();
        block0: for (Object view : diagramPart.getViewer().getEditPartRegistry().keySet()) {
            Object editpart;
            if (!(view instanceof View) || !((editpart = diagramPart.getViewer().getEditPartRegistry().get(view)) instanceof IGraphicalEditPart) || !(editpart instanceof IPrimaryEditPart) || groupEditPart.equals(editpart)) continue;
            IGraphicalEditPart part = (IGraphicalEditPart)editpart;
            boolean boundsOK = false;
            if (groupEditPart.getChildren().contains(editpart)) {
                boundsOK = true;
            } else {
                Rectangle figBounds = part.getFigure().getBounds().getCopy();
                part.getFigure().translateToAbsolute((Translatable)figBounds);
                if (contentArea.contains(figBounds)) {
                    boundsOK = true;
                }
            }
            if (!boundsOK) continue;
            EObject child = part.resolveSemanticElement();
            for (EReference refToChildren : descriptor.getChildrenReferences()) {
                if (!refToChildren.getEReferenceType().isInstance((Object)child)) continue;
                groupParts.add(part);
                continue block0;
            }
        }
        return new ArrayList<IGraphicalEditPart>(groupParts);
    }

    public static void drawRect(IGraphicalEditPart editPart, Rectangle refContentArea) {
        RoundedRectangle rectFeedback = new RoundedRectangle();
        rectFeedback.setBounds(refContentArea);
        rectFeedback.setCornerDimensions(new Dimension(0, 0));
        rectFeedback.setLineWidth(2);
        rectFeedback.setLineStyle(2);
        rectFeedback.setForegroundColor(editPart.getFigure().getForegroundColor());
        rectFeedback.setOpaque(true);
        rectFeedback.setFill(false);
        IFigure layer = LayerManager.Helper.find((EditPart)editPart).getLayer((Object)"Feedback Layer");
        layer.add((IFigure)rectFeedback);
    }

    public static Command getUpdateGraphicalParentCmd(IGraphicalEditPart childPart, IGraphicalEditPart newParent) {
        if (childPart.getParent().equals(newParent)) {
            return null;
        }
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setMoveDelta(new Point(0, 0));
        request.setSizeDelta(new Dimension(0, 0));
        request.setEditParts((EditPart)childPart);
        Point loc = childPart.getFigure().getBounds().getLocation().getCopy();
        childPart.getFigure().translateToAbsolute((Translatable)loc);
        request.setLocation(loc);
        request.setType((Object)"drop");
        org.eclipse.gef.commands.Command cmd = newParent.getCommand((Request)request);
        if (cmd != null && cmd.canExecute()) {
            return new GEFtoEMFCommandWrapper(cmd);
        }
        return null;
    }

    public static Command getAddReferenceToChildCmd(IGraphicalEditPart newParentpart, IGraphicalEditPart newChildPart) {
        AbstractContainerNodeDescriptor desc = GroupContainmentRegistry.getContainerDescriptor(newParentpart);
        EObject parent = newParentpart.resolveSemanticElement();
        EObject child = newChildPart.resolveSemanticElement();
        EReference usedReference = Utils.getBestReferenceAmongList(desc.getChildrenReferences(), child);
        if (usedReference != null) {
            return new AddCommand((EditingDomain)newParentpart.getEditingDomain(), parent, (EStructuralFeature)usedReference, (Object)child);
        }
        return null;
    }

    public static EReference getBestReferenceAmongList(List<EReference> childrenReferences, EObject child) {
        EReference usedReference = null;
        for (EReference ref : childrenReferences) {
            if (!ref.getEReferenceType().isInstance((Object)child) || usedReference != null && !ref.getEReferenceType().getEAllSuperTypes().contains((Object)usedReference.getEReferenceType())) continue;
            usedReference = ref;
        }
        return usedReference;
    }

    public static Command getRemoveReferenceToChildCmd(IGraphicalEditPart oldParentpart, IGraphicalEditPart oldChildPart) {
        AbstractContainerNodeDescriptor desc = GroupContainmentRegistry.getContainerDescriptor(oldParentpart);
        EObject parent = oldParentpart.resolveSemanticElement();
        EObject child = oldChildPart.resolveSemanticElement();
        CompoundCommand globalCmd = new CompoundCommand();
        EStructuralFeature usedReference = null;
        for (EReference ref : desc.getChildrenReferences()) {
            RemoveCommand cmd;
            if (!(parent.eGet((EStructuralFeature)ref) instanceof List) || !((List)parent.eGet((EStructuralFeature)ref)).contains(child) || !(cmd = new RemoveCommand((EditingDomain)oldParentpart.getEditingDomain(), parent, usedReference, (Object)child)).canExecute()) continue;
            globalCmd.append((Command)cmd);
        }
        if (!globalCmd.isEmpty()) {
            return globalCmd;
        }
        return null;
    }

    public static Rectangle getAbsoluteBounds(IGraphicalEditPart part) {
        Node node;
        LayoutConstraint cst;
        part.getTopGraphicEditPart().refresh();
        Rectangle bounds = part.getFigure().getBounds().getCopy();
        if (part.getNotationView() instanceof Node && (cst = (node = (Node)part.getNotationView()).getLayoutConstraint()) instanceof Bounds) {
            Bounds b = (Bounds)cst;
            Point parentLoc = part.getFigure().getParent().getBounds().getLocation();
            if (b.getX() > 0) {
                bounds.x = b.getX() + parentLoc.x;
            }
            if (b.getY() > 0) {
                bounds.y = b.getY() + parentLoc.y;
            }
            if (b.getHeight() != -1) {
                bounds.height = b.getHeight();
            }
            if (b.getWidth() != -1) {
                bounds.width = b.getWidth();
            }
        }
        part.getFigure().getParent().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Dimension computeDeltaToChangeParent(IGraphicalEditPart oldParent, IGraphicalEditPart newParent) {
        Rectangle hostBounds = Utils.getAbsoluteBounds(oldParent);
        Rectangle parentBounds = Utils.getAbsoluteBounds(newParent);
        Dimension delta = hostBounds.getLocation().getDifference(parentBounds.getLocation());
        return delta;
    }

    public static Dimension computeDeltaToChangeParent(IGraphicalEditPart oldParent, Rectangle newParent) {
        Rectangle hostBounds = Utils.getAbsoluteBounds(oldParent);
        Dimension delta = hostBounds.getLocation().getDifference(newParent.getLocation());
        return delta;
    }

    public static EReference getContainmentEReference(EClass parentType, EClass childType) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        EReference usedReference = null;
        for (EReference reference : parentType.getEAllContainments()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || reference.isDerived()) continue;
            result.add(reference);
        }
        for (EReference ref : result) {
            if (usedReference != null && !ref.getEReferenceType().getEAllSuperTypes().contains((Object)usedReference.getEReferenceType())) continue;
            usedReference = ref;
        }
        return usedReference;
    }

    public static boolean isContainedInRegistery(Map editPartRegistry, Object _child) {
        if (_child instanceof IGraphicalEditPart) {
            return editPartRegistry.containsKey(((IGraphicalEditPart)_child).getModel());
        }
        return false;
    }

    public static boolean isAGoodCompartementEditPart(Map editPartRegistry, Object _child) {
        return _child instanceof CompartmentEditPart && Utils.isContainedInRegistery(editPartRegistry, _child) && (EditPart)_child instanceof ShapeCompartmentEditPart;
    }

    public static EditPart getCompartementEditPartFromMainEditPart(Map editPartRegistry, EditPart parentEditPart) {
        EditPart resultCompartmentEditPart = null;
        if (parentEditPart instanceof CompartmentEditPart) {
            resultCompartmentEditPart = parentEditPart;
            return resultCompartmentEditPart;
        }
        ArrayList<EditPart> potentialCompartementPart = new ArrayList<EditPart>();
        for (Object _child : parentEditPart.getChildren()) {
            if (!Utils.isAGoodCompartementEditPart(editPartRegistry, _child)) continue;
            potentialCompartementPart.add((EditPart)_child);
        }
        if (potentialCompartementPart.size() == 1) {
            resultCompartmentEditPart = (EditPart)potentialCompartementPart.get(0);
            return resultCompartmentEditPart;
        }
        if (potentialCompartementPart.size() == 1) {
            resultCompartmentEditPart = (EditPart)potentialCompartementPart.get(0);
            return resultCompartmentEditPart;
        }
        return resultCompartmentEditPart;
    }

    public static DefaultModelParent getDefaultModelParent(EClass elementType, IGraphicalEditPart getHost) {
        IGraphicalEditPart hostParent = getHost;
        while (hostParent != null) {
            EObject hostParentElement = hostParent.resolveSemanticElement();
            if (GroupContainmentRegistry.getDescriptorsWithContainerEClass(hostParentElement.eClass()).isEmpty()) {
                for (EReference containmentRelation : hostParentElement.eClass().getEAllContainments()) {
                    if (!containmentRelation.getEReferenceType().isSuperTypeOf(elementType)) continue;
                    return new DefaultModelParent(hostParent, containmentRelation);
                }
            }
            hostParent = (IGraphicalEditPart)hostParent.getParent();
        }
        return null;
    }

    public static boolean isRequestGroupFrameworkConcerned(ChangeBoundsRequest request) {
        for (Object editPart : request.getEditParts()) {
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)editPart;
            boolean isNodeConcerned = GroupContainmentRegistry.isNodeConcerned(iGraphicalEditPart);
            boolean isGroupConcerned = GroupContainmentRegistry.isContainerConcerned(iGraphicalEditPart);
            if (!isGroupConcerned && !isNodeConcerned) continue;
            return true;
        }
        return false;
    }
}

