/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.groups.listeners;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.diagram.common.groups.request.EdgeGroupFrameworkRequest;
import org.eclipse.papyrus.diagram.common.groups.request.ReferenceGroupFrameworkRequest;
import org.eclipse.papyrus.diagram.common.listeners.AbstractModifcationTriggerListener;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementChangeGroupListener
extends AbstractModifcationTriggerListener<Element> {
    protected ImmutableSortedSet<EReference> registry;

    public ElementChangeGroupListener() {
        this.initExtensionPoint();
    }

    private void initExtensionPoint() {
        Comparator<EStructuralFeature> eStructuralFeatureCompartor = new Comparator<EStructuralFeature>(){

            @Override
            public int compare(EStructuralFeature arg0, EStructuralFeature arg1) {
                Integer val1 = arg0.getFeatureID();
                Integer val2 = arg1.getFeatureID();
                return val1.compareTo(val2);
            }
        };
        this.registry = ImmutableSortedSet.copyOf((Comparator)eStructuralFeatureCompartor, GroupContainmentRegistry.getAllERefencesFromNodeToGroup());
    }

    protected Element getElement(Notification notif) {
        Object element = notif.getNotifier();
        if (element instanceof Element) {
            return (Element)element;
        }
        return null;
    }

    protected boolean isCorrectStructuralfeature(EStructuralFeature eStructuralFeature) {
        return false;
    }

    protected ICommand getModificationCommand(Notification notif, TransactionalEditingDomain domain) {
        CompositeCommand notificationCommand = new CompositeCommand("Element change group trigger action");
        boolean setMode = notif.getNewValue() != null;
        Object feature = notif.getFeature();
        IGraphicalEditPart part = this.getChildByEObject((EObject)this.getElement(notif), (IGraphicalEditPart)this.getDiagramEditPart(), false);
        if (feature instanceof EStructuralFeature && part != null) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)feature;
            ReferenceGroupFrameworkRequest referenceGroupRequest = new ReferenceGroupFrameworkRequest((EObject)notif.getNewValue(), (EObject)notif.getOldValue(), (EObject)this.getElement(notif), eStructuralFeature);
            referenceGroupRequest.setType(ReferenceGroupFrameworkRequest.REFERENCED_GROUP_REQUEST);
            Command referenceGroupOnChildCommand = part.getCommand((Request)referenceGroupRequest);
            if (referenceGroupOnChildCommand != null && referenceGroupOnChildCommand.canExecute()) {
                notificationCommand.compose((IUndoableOperation)new CommandProxy(referenceGroupOnChildCommand));
            }
            Map registry = part.getViewer().getEditPartRegistry();
            Object model = part.getModel();
            if (model instanceof Node) {
                this.notifyEdge(part, notificationCommand, registry, model, EdgeGroupFrameworkRequest.EdgeType.TARGET, setMode);
                this.notifyEdge(part, notificationCommand, registry, model, EdgeGroupFrameworkRequest.EdgeType.SOURCE, setMode);
            }
        }
        return notificationCommand;
    }

    protected void notifyEdge(IGraphicalEditPart parent, CompositeCommand notificationCommand, Map registry, Object model, EdgeGroupFrameworkRequest.EdgeType type, boolean isSetMode) {
        EList edges = null;
        switch (type) {
            case TARGET: {
                edges = ((Node)model).getTargetEdges();
                break;
            }
            default: {
                edges = ((Node)model).getSourceEdges();
            }
        }
        for (Object egde : edges) {
            EdgeGroupFrameworkRequest edgeGroupRequet;
            Command cmd;
            Object editPart;
            if (!(egde instanceof Edge) || !((editPart = registry.get(egde)) instanceof IGraphicalEditPart) || (cmd = ((IGraphicalEditPart)editPart).getCommand((Request)(edgeGroupRequet = new EdgeGroupFrameworkRequest(type, parent.resolveSemanticElement(), isSetMode)))) == null || !cmd.canExecute()) continue;
            notificationCommand.compose((IUndoableOperation)new CommandProxy(cmd));
        }
    }
}

