/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customaction.control;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.diagram.common.palette.customaction.providers.Tool;
import org.eclipse.papyrus.diagram.common.palette.customaction.providers.ToolAspectAction;
import org.eclipse.papyrus.diagram.common.palette.customaction.swt.SWTResourceManager;
import org.eclipse.papyrus.diagram.common.palette.customaction.utils.ICallback;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSelectionComposite
extends Composite {
    private ComboViewer viewer;
    private final ICallback<Tool> callBack;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    FormText label = null;

    public ToolSelectionComposite(Composite parent, IPaletteEntryProxy entryProxy, int style, ICallback<Tool> call) {
        super(parent, style);
        this.callBack = call;
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.viewer = new ComboViewer((Composite)this);
        this.viewer.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structured;
                Tool firstElement;
                if (event.getSelection() instanceof IStructuredSelection && (firstElement = (Tool)(structured = (IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    String description = firstElement.getDescription();
                    if (description != null && description.length() > 0) {
                        ToolSelectionComposite.this.label.setText(description, true, true);
                    }
                    ToolSelectionComposite.this.callBack.callBack(firstElement);
                }
            }
        });
        Group group = new Group((Composite)this, 16);
        group.setText("Description");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.label = this.formToolkit.createFormText((Composite)group, false);
        this.label.setBackground(SWTResourceManager.getColor(22));
        this.label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.paintBordersFor((Composite)this.label);
        this.label.setText("", false, true);
        this.viewer.setInput(ToolAspectAction.getFiltered(entryProxy, ToolAspectAction.getAllExtensions()));
    }

    public void setSelection(Node configurationNode) {
        Tool wizard = ToolSelectionComposite.getTool(configurationNode);
        if (wizard != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)wizard));
        }
    }

    public static Tool getTool(Node configurationNode) {
        if (configurationNode == null || configurationNode.getAttributes() == null) {
            return null;
        }
        Node attr = configurationNode.getAttributes().getNamedItem("AspectPredefinedTool");
        if (attr != null) {
            String value = attr.getNodeValue();
            Tool wizard = ToolAspectAction.getExtension(value);
            return wizard;
        }
        return null;
    }

    public void setSelection(Tool selection) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)selection));
    }
}

