/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelContentProvider;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.Messages;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.AspectActionsInformationComposite;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.ConfigurationInformationComposite;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteContainerProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteLocalDrawerProxy;
import org.eclipse.papyrus.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.papyrus.diagram.common.service.palette.StereotypeAspectActionProvider;
import org.eclipse.papyrus.paletteconfiguration.ChildConfiguration;
import org.eclipse.papyrus.paletteconfiguration.Configuration;
import org.eclipse.papyrus.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.paletteconfiguration.LeafConfiguration;
import org.eclipse.papyrus.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.paletteconfiguration.PaletteconfigurationPackage;
import org.eclipse.papyrus.paletteconfiguration.SeparatorConfiguration;
import org.eclipse.papyrus.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.paletteconfiguration.util.PaletteConfigurationUtils;
import org.eclipse.papyrus.paletteconfiguration.util.PaletteconfigurationSwitch;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPaletteContentPage
extends WizardPage
implements Listener {
    protected IEditorPart editorPart;
    protected TreeViewer availableToolsViewer;
    protected PaletteLabelProvider paletteLabelProvider;
    protected static final String HIDDEN_TOOLS_ICON = "/icons/tools_hidden.gif";
    protected static final String SHOWN_TOOLS_ICON = "/icons/tools_shown.gif";
    protected static final String WIZARD_ICON = "/icons/local_desc_wiz.png";
    protected static final String SHOWN_DRAWERS_ICON = "/icons/drawers_shown.gif";
    protected static final String HIDDEN_DRAWERS_ICON = "/icons/drawers_hidden.gif";
    protected static final String ADD_ICON = "/icons/arrow_right.gif";
    protected static final String REMOVE_ICON = "/icons/arrow_left.gif";
    protected static final String DELETE_ICON = "/icons/delete.gif";
    protected static final String CREATE_DRAWERS_ICON = "/icons/new_drawer.gif";
    protected String CREATE_SEPARATOR_ICON = "/icons/separator.gif";
    protected String CREATE_STACK_ICON = "/icons/stack.gif";
    protected static final String DELETE_DRAWERS_ICON = "/icons/delete.gif";
    protected String SWITCH_CONTENT_PROVIDER_ICON = "/icons/switch_provider.gif";
    protected static final String UML_TOOLS_LABEL = "UML tools";
    protected static final String EDIT_ICON = "/icons/obj16/file.gif";
    protected final ViewerFilter drawerFilter = new DrawerFilter();
    protected final ViewerFilter toolFilter = new ToolFilter();
    protected List<String> storedPreferences;
    protected Button addButton;
    protected Button removeButton;
    protected TreeViewer paletteTreeViewer;
    protected Document document;
    protected PaletteContainerProxy contentNode;
    protected Combo profileCombo;
    protected List<String> profileComboList = new ArrayList<String>();
    protected ToolItem toggleContentProvider;
    protected Set<String> requiredProfiles;
    protected PaletteCustomizer customizer;
    protected Configuration selectedConfiguration;
    protected ConfigurationInformationComposite informationComposite = new ConfigurationInformationComposite();
    protected AspectActionsInformationComposite aspectActionComposite = new AspectActionsInformationComposite();
    protected ToolBar toolbar;
    protected static final String VALIDATOR = "validator";
    protected ProviderPriority priority;
    private ResourceSet resourceSet;
    private Resource resourceToEdit;
    private CustomizationManager manager = new CustomizationManager();

    public ExtendedPaletteContentPage(IEditorPart part, PaletteCustomizer customizer) {
        super(Messages.Local_Palette_ContentPage_Name, Messages.Local_Palette_ContentPage_Title, Activator.getImageDescriptor((String)WIZARD_ICON));
        this.editorPart = part;
        this.customizer = customizer;
    }

    public void setPriority(ProviderPriority priority) {
        this.priority = priority;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Resource getResourceToEdit() {
        return this.resourceToEdit;
    }

    public Set<String> getRequiredProfiles() {
        return this.requiredProfiles;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.createAvailableToolsGroup();
        this.createAddRemoveButtons();
        this.createPalettePreviewGroup();
        this.createToolDescriptionGroup();
        this.createAspectActionComposite();
        ISelectionChangedListener listener = this.createToolsViewerSelectionChangeListener();
        this.availableToolsViewer.addSelectionChangedListener(listener);
        this.paletteTreeViewer.addSelectionChangedListener(listener);
        this.resourceToEdit.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                ExtendedPaletteContentPage.this.paletteTreeViewer.refresh();
            }
        });
        Dialog.applyDialogFont((Control)control);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)control);
    }

    protected void createAspectActionComposite() {
        this.aspectActionComposite.createComposite((Composite)this.getControl(), this.getAllAppliedProfiles());
    }

    protected void createToolDescriptionGroup() {
        this.informationComposite.createComposite((Composite)this.getControl(), this.getAllAppliedProfiles());
    }

    protected void updatePreferences() {
        this.storedPreferences = PapyrusPalettePreferences.getHiddenPalettes((IEditorPart)this.editorPart);
        for (String id : this.storedPreferences) {
            PapyrusPalettePreferences.changePaletteVisibility((String)id, (IEditorPart)this.editorPart, (boolean)true);
        }
    }

    public void restorePreferences() {
        for (String id : this.storedPreferences) {
            PapyrusPalettePreferences.changePaletteVisibility((String)id, (IEditorPart)this.editorPart, (boolean)false);
        }
    }

    protected void createPalettePreviewGroup() {
        Composite parent = (Composite)this.getControl();
        Composite paletteComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paletteComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        paletteComposite.setLayoutData((Object)data);
        Label label = new Label(paletteComposite, 0);
        label.setText(Messages.Local_Palette_Palette_Preview);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.toolbar = new ToolBar(paletteComposite, 256);
        data = new GridData(131072, 4, false, false);
        this.toolbar.setLayoutData((Object)data);
        this.populatePalettePreviewToolBar(this.toolbar);
        Tree tree = new Tree(paletteComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 185;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.paletteTreeViewer = new TreeViewer(tree);
        this.paletteTreeViewer.setContentProvider((IContentProvider)new ExtendedPaletteContentProvider());
        this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new ExtendedPaletteLabelProvider());
        this.paletteTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExtendedPaletteContentPage.this.handlePalettePreviewSelectionChanged(event);
            }
        });
        this.addPalettePreviewDropSupport();
        this.addPalettePreviewDragSupport();
        this.addPalettePreviewEditSupport();
        this.paletteTreeViewer.setInput((Object)this.resourceToEdit);
    }

    protected void handlePalettePreviewSelectionChanged(SelectionChangedEvent event) {
        Configuration configuration = this.getSelectedConfiguration();
        if (configuration != null) {
            this.selectedConfiguration = configuration;
            this.informationComposite.setSelectedConfiguration(this.selectedConfiguration);
        } else {
            this.selectedConfiguration = null;
            this.informationComposite.setSelectedConfiguration(null);
        }
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            int i = 0;
            while (i < this.toolbar.getItemCount()) {
                ToolItem item = this.toolbar.getItem(i);
                Object validator = item.getData(VALIDATOR);
                if (validator instanceof ToolBarItemValidator) {
                    item.setEnabled(((ToolBarItemValidator)validator).isEnable());
                }
                ++i;
            }
        }
    }

    protected void addPalettePreviewEditSupport() {
        this.paletteTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    protected void addPalettePreviewDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        TreeDropTargetEffect listener = new TreeDropTargetEffect(this.paletteTreeViewer.getTree()){

            public void drop(DropTargetEvent event) {
                super.drop(event);
                IStructuredSelection transferedSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType);
                Object objectToTransfer = transferedSelection.getFirstElement();
                if (!(objectToTransfer instanceof IAdaptable)) {
                    return;
                }
                EObject eobjectToTransfer = (EObject)((IAdaptable)objectToTransfer).getAdapter(EObject.class);
                Object targetObject = ((TreeItem)event.item).getData();
                if (!(targetObject instanceof IAdaptable)) {
                    return;
                }
                final EObject targetEObject = (EObject)((IAdaptable)targetObject).getAdapter(EObject.class);
                if (targetEObject == null) {
                    return;
                }
                new PaletteconfigurationSwitch<Object>(){

                    public Object caseDrawerConfiguration(DrawerConfiguration drawerConfigurationToMove) {
                        if (targetEObject instanceof DrawerConfiguration) {
                            PaletteConfiguration paletteConfiguration = (PaletteConfiguration)((DrawerConfiguration)targetEObject).eContainer();
                            PaletteConfigurationUtils.moveDrawerConfiguration((PaletteConfiguration)paletteConfiguration, (DrawerConfiguration)drawerConfigurationToMove, (DrawerConfiguration)((DrawerConfiguration)targetEObject));
                        }
                        return super.caseDrawerConfiguration(drawerConfigurationToMove);
                    }

                    public Object caseSeparatorConfiguration(SeparatorConfiguration separatorConfigurationToMove) {
                        if (targetEObject instanceof DrawerConfiguration) {
                            PaletteConfigurationUtils.moveSeparatorConfiguration((DrawerConfiguration)((DrawerConfiguration)targetEObject), (SeparatorConfiguration)separatorConfigurationToMove);
                        } else if (targetEObject instanceof StackConfiguration) {
                            PaletteConfigurationUtils.moveSeparatorConfiguration((ChildConfiguration)((StackConfiguration)targetEObject), (SeparatorConfiguration)separatorConfigurationToMove);
                        } else if (targetEObject instanceof ToolConfiguration) {
                            PaletteConfigurationUtils.moveSeparatorConfiguration((ChildConfiguration)((ToolConfiguration)targetEObject), (SeparatorConfiguration)separatorConfigurationToMove);
                        } else if (targetEObject instanceof SeparatorConfiguration) {
                            PaletteConfigurationUtils.moveSeparatorConfiguration((ChildConfiguration)((SeparatorConfiguration)targetEObject), (SeparatorConfiguration)separatorConfigurationToMove);
                        }
                        return super.caseSeparatorConfiguration(separatorConfigurationToMove);
                    }

                    public Object caseStackConfiguration(StackConfiguration stackConfigurationToMove) {
                        if (targetEObject instanceof DrawerConfiguration) {
                            PaletteConfigurationUtils.moveStackConfiguration((DrawerConfiguration)((DrawerConfiguration)targetEObject), (StackConfiguration)stackConfigurationToMove);
                        } else if (targetEObject instanceof StackConfiguration) {
                            PaletteConfigurationUtils.moveStackConfiguration((ChildConfiguration)((StackConfiguration)targetEObject), (StackConfiguration)stackConfigurationToMove);
                        } else if (targetEObject instanceof ToolConfiguration) {
                            PaletteConfigurationUtils.moveStackConfiguration((ChildConfiguration)((ToolConfiguration)targetEObject), (StackConfiguration)stackConfigurationToMove);
                        } else if (targetEObject instanceof SeparatorConfiguration) {
                            PaletteConfigurationUtils.moveStackConfiguration((ChildConfiguration)((SeparatorConfiguration)targetEObject), (StackConfiguration)stackConfigurationToMove);
                        }
                        return super.caseStackConfiguration(stackConfigurationToMove);
                    }

                    public Object caseToolConfiguration(ToolConfiguration toolConfigurationToMove) {
                        if (targetEObject instanceof DrawerConfiguration) {
                            PaletteConfigurationUtils.moveToolConfiguration((DrawerConfiguration)((DrawerConfiguration)targetEObject), (ToolConfiguration)toolConfigurationToMove);
                        } else if (targetEObject instanceof StackConfiguration) {
                            PaletteConfigurationUtils.moveToolConfiguration((StackConfiguration)((StackConfiguration)targetEObject), (ToolConfiguration)toolConfigurationToMove);
                        } else if (targetEObject instanceof ToolConfiguration) {
                            PaletteConfigurationUtils.moveToolConfiguration((ChildConfiguration)((ToolConfiguration)targetEObject), (ToolConfiguration)toolConfigurationToMove);
                        } else if (targetEObject instanceof SeparatorConfiguration) {
                            PaletteConfigurationUtils.moveToolConfiguration((ChildConfiguration)((SeparatorConfiguration)targetEObject), (ToolConfiguration)toolConfigurationToMove);
                        }
                        return super.caseToolConfiguration(toolConfigurationToMove);
                    }
                }.doSwitch(eobjectToTransfer);
                ExtendedPaletteContentPage.this.setPageComplete(ExtendedPaletteContentPage.this.validatePage());
            }

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
                IStructuredSelection transferedSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType);
                TreeItem item = ExtendedPaletteContentPage.this.paletteTreeViewer.getTree().getItem(ExtendedPaletteContentPage.this.paletteTreeViewer.getTree().toControl(new Point(event.x, event.y)));
                ExtendedPaletteContentPage.this.checkSelectionForDrop(transferedSelection, item, event);
            }
        };
        this.paletteTreeViewer.addDropSupport(6, transfers, (DropTargetListener)listener);
    }

    protected void addPalettePreviewDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                event.data = ExtendedPaletteContentPage.this.paletteTreeViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
                LocalSelectionTransfer.getTransfer().setSelection(ExtendedPaletteContentPage.this.paletteTreeViewer.getSelection());
            }
        };
        this.paletteTreeViewer.addDragSupport(2, transfers, (DragSourceListener)listener);
    }

    protected void checkSelectionForDrop(IStructuredSelection transferedSelection, TreeItem item, final DropTargetEvent event) {
        event.detail = 0;
        Object objectToTransfer = transferedSelection.getFirstElement();
        if (!(objectToTransfer instanceof IAdaptable)) {
            return;
        }
        EObject eobjectToTransfer = (EObject)((IAdaptable)objectToTransfer).getAdapter(EObject.class);
        if (item == null) {
            if (eobjectToTransfer instanceof DrawerConfiguration) {
                event.detail = 4;
            }
        } else {
            Object targetObject = item.getData();
            if (!(targetObject instanceof IAdaptable)) {
                event.detail = 0;
                return;
            }
            final EObject targetEObject = (EObject)((IAdaptable)targetObject).getAdapter(EObject.class);
            if (targetEObject == null) {
                event.detail = 0;
                return;
            }
            new PaletteconfigurationSwitch<Object>(){

                public Object caseDrawerConfiguration(DrawerConfiguration object) {
                    if (targetEObject instanceof DrawerConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    }
                    return object;
                }

                public Object caseSeparatorConfiguration(SeparatorConfiguration object) {
                    if (targetEObject instanceof DrawerConfiguration) {
                        event.detail = 2;
                    } else if (targetEObject instanceof StackConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    } else if (targetEObject instanceof ToolConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    } else if (targetEObject instanceof SeparatorConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    }
                    return object;
                }

                public Object caseStackConfiguration(StackConfiguration object) {
                    if (targetEObject instanceof DrawerConfiguration) {
                        event.detail = 2;
                    } else if (targetEObject instanceof StackConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    } else if (targetEObject instanceof ToolConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    } else if (targetEObject instanceof SeparatorConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    }
                    return object;
                }

                public Object caseToolConfiguration(ToolConfiguration object) {
                    if (targetEObject instanceof DrawerConfiguration) {
                        event.detail = 2;
                    } else if (targetEObject instanceof StackConfiguration) {
                        event.detail = 2;
                    } else if (targetEObject instanceof ToolConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    } else if (targetEObject instanceof SeparatorConfiguration) {
                        event.detail = 2;
                        event.feedback = 2;
                    }
                    return object;
                }
            }.doSwitch(eobjectToTransfer);
        }
    }

    public void initializeContent() {
        this.contentNode = new PaletteContainerProxy(null);
        PaletteLocalDrawerProxy proxy = new PaletteLocalDrawerProxy("Default", this.generateID("Drawer_"), "/icons/drawer.gif", "Default Drawer");
        this.contentNode.addChild(proxy);
        this.setPageComplete(false);
    }

    public void initializeContent(PapyrusPaletteService.ExtendedProviderDescriptor descriptor) {
        this.resourceSet = this.createResourceSet();
        this.resourceToEdit = this.getResourceSet().createResource(descriptor.getRedefinitionFileURI());
        if (this.resourceToEdit == null) {
            Activator.log.error("No resource has been created for uri :" + descriptor.getRedefinitionFileURI(), null);
        }
        try {
            this.resourceToEdit.load(Collections.emptyMap());
        }
        catch (IOException e) {
            Activator.log.error("Impossible to load configuration file", (Throwable)e);
        }
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    protected void populatePalettePreviewToolBar(ToolBar toolbar) {
        ConfigurationSelectedValidator validator = new ConfigurationSelectedValidator();
        DrawerConfigurationSelectedValidator drawerConfigurationSelectedValidator = new DrawerConfigurationSelectedValidator();
        this.createToolBarItem(toolbar, "/icons/delete.gif", Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip, this.createRemoveElementListener(), validator);
        this.createToolBarItem(toolbar, CREATE_DRAWERS_ICON, Messages.Local_Palette_Create_Drawer_Tooltip, this.createNewDrawerListener(), null);
        this.createToolBarItem(toolbar, this.CREATE_SEPARATOR_ICON, Messages.Local_Palette_Create_Separator_Tooltip, this.createNewSeparatorListener(), validator);
        this.createToolBarItem(toolbar, this.CREATE_STACK_ICON, Messages.Local_Palette_Create_Stack_Tooltip, this.createNewStackListener(), drawerConfigurationSelectedValidator);
    }

    protected Listener createRemoveElementListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)ExtendedPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                for (Object o : selection) {
                    EObject eobject;
                    if (!(o instanceof IAdaptable) || !((eobject = (EObject)((IAdaptable)o).getAdapter(EObject.class)) instanceof Configuration)) continue;
                    PaletteConfigurationUtils.removeConfiguration((Configuration)((Configuration)eobject));
                }
            }
        };
    }

    protected Listener createNewDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                PaletteConfiguration paletteConfiguration = (PaletteConfiguration)EcoreUtil.getObjectByType((Collection)ExtendedPaletteContentPage.this.resourceToEdit.getContents(), (EClassifier)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration());
                if (paletteConfiguration != null) {
                    PaletteConfigurationUtils.createDrawer((PaletteConfiguration)paletteConfiguration);
                } else {
                    Activator.log.error("Impossible to find the palette configuration", null);
                }
                ExtendedPaletteContentPage.this.setPageComplete(ExtendedPaletteContentPage.this.validatePage());
            }
        };
    }

    protected Listener createNewStackListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Configuration selectedConfiguration = ExtendedPaletteContentPage.this.getSelectedConfiguration();
                if (selectedConfiguration instanceof DrawerConfiguration) {
                    PaletteConfigurationUtils.createStack((DrawerConfiguration)((DrawerConfiguration)selectedConfiguration));
                } else if (selectedConfiguration instanceof LeafConfiguration) {
                    PaletteConfigurationUtils.createStack((LeafConfiguration)((LeafConfiguration)selectedConfiguration));
                } else {
                    Activator.log.error("Invalid selection to create a Stack: " + selectedConfiguration, null);
                }
                ExtendedPaletteContentPage.this.setPageComplete(ExtendedPaletteContentPage.this.validatePage());
            }
        };
    }

    protected String generateID(String base) {
        StringBuffer id = new StringBuffer();
        id.append(base);
        id.append("_");
        id.append(System.currentTimeMillis());
        return id.toString();
    }

    protected Listener createNewSeparatorListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Configuration selectedConfiguration = ExtendedPaletteContentPage.this.getSelectedConfiguration();
                if (selectedConfiguration instanceof DrawerConfiguration) {
                    PaletteConfigurationUtils.createSeparator((DrawerConfiguration)((DrawerConfiguration)selectedConfiguration));
                } else if (selectedConfiguration instanceof LeafConfiguration) {
                    PaletteConfigurationUtils.createSeparator((LeafConfiguration)((LeafConfiguration)selectedConfiguration));
                } else {
                    Activator.log.error("Invalid selection to create a separator: " + selectedConfiguration, null);
                }
                ExtendedPaletteContentPage.this.setPageComplete(ExtendedPaletteContentPage.this.validatePage());
            }
        };
    }

    protected Configuration getSelectedConfiguration() {
        if (this.paletteTreeViewer != null && !this.paletteTreeViewer.getControl().isDisposed()) {
            EObject eobject;
            IStructuredSelection selection = (IStructuredSelection)this.paletteTreeViewer.getSelection();
            if (selection == null) {
                return null;
            }
            Object object = selection.getFirstElement();
            if (object instanceof IAdaptable && (eobject = (EObject)((IAdaptable)object).getAdapter(EObject.class)) instanceof Configuration) {
                return (Configuration)eobject;
            }
        }
        return null;
    }

    protected void createToolBarItem(ToolBar toolbar, String itemIcon, String tooltip, Listener listener, ToolBarItemValidator validator) {
        ToolItem item = new ToolItem(toolbar, 2048);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (String)itemIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        item.setData(VALIDATOR, (Object)validator);
    }

    protected void createAddRemoveButtons() {
        Composite composite = new Composite((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, false, true);
        composite.setLayoutData((Object)data);
        this.addButton = new Button(composite, 0);
        this.addButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (String)ADD_ICON));
        this.addButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_AddButtonTooltip);
        this.addButton.addMouseListener(this.createAddButtonListener());
        this.addButton.setEnabled(false);
        this.addButton.addListener(4, (Listener)this);
        this.removeButton = new Button(composite, 0);
        this.removeButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (String)REMOVE_ICON));
        this.removeButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip);
        this.removeButton.addMouseListener(this.createRemoveButtonListener());
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(4, (Listener)this);
    }

    protected ISelectionChangedListener createToolsViewerSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object target;
                Object source = ((IStructuredSelection)ExtendedPaletteContentPage.this.availableToolsViewer.getSelection()).getFirstElement();
                if (this.isAddValidTarget(source, target = ((IStructuredSelection)ExtendedPaletteContentPage.this.paletteTreeViewer.getSelection()).getFirstElement())) {
                    ExtendedPaletteContentPage.this.addButton.setEnabled(true);
                } else {
                    ExtendedPaletteContentPage.this.addButton.setEnabled(false);
                }
                if (this.isRemoveValidSource(target)) {
                    ExtendedPaletteContentPage.this.removeButton.setEnabled(true);
                } else {
                    ExtendedPaletteContentPage.this.removeButton.setEnabled(false);
                }
            }

            protected boolean isAddValidTarget(Object source, Object target) {
                if (!(source instanceof PaletteEntry)) {
                    return false;
                }
                if (source instanceof PaletteDrawer) {
                    return target == null;
                }
                if (source instanceof ToolEntry) {
                    boolean cfr_ignored_0 = target instanceof PaletteEntryProxy;
                    return false;
                }
                return false;
            }

            protected boolean isRemoveValidSource(Object source) {
                return source instanceof PaletteEntryProxy;
            }
        };
    }

    protected MouseListener createAddButtonListener() {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    protected MouseListener createRemoveButtonListener() {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExtendedPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                PaletteEntryProxy proxyToDelete = (PaletteEntryProxy)selection.getFirstElement();
                if (proxyToDelete == null) {
                    return;
                }
                PaletteContainerProxy parentProxy = proxyToDelete.getParent();
                parentProxy.removeChild(proxyToDelete);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    protected void createAvailableToolsGroup() {
        Composite parent = (Composite)this.getControl();
        Composite availableToolsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        availableToolsComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        availableToolsComposite.setLayoutData((Object)data);
        Label label = new Label(availableToolsComposite, 0);
        label.setText(Messages.Local_Palette_Available_Tools);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        ToolBar toolbar = new ToolBar(availableToolsComposite, 256);
        data = new GridData(131072, 4, false, false);
        toolbar.setLayoutData((Object)data);
        this.populateAvailableToolsToolBar(toolbar);
        this.createProfileCombo(availableToolsComposite);
        Tree tree = new Tree(availableToolsComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 185;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.availableToolsViewer = new TreeViewer(tree);
        this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
        this.paletteLabelProvider = new PaletteLabelProvider();
        this.availableToolsViewer.setLabelProvider((IBaseLabelProvider)this.paletteLabelProvider);
        LabelViewerComparator labelComparator = new LabelViewerComparator();
        this.availableToolsViewer.setComparator((ViewerComparator)labelComparator);
        this.availableToolsViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof PaletteStack && "noteStack".equals(((PaletteStack)element).getId())) {
                    return false;
                }
                return !(element instanceof PaletteToolbar) || !"standardGroup".equals(((PaletteToolbar)element).getId());
            }
        });
        this.availableToolsViewer.addFilter((ViewerFilter)new DrawerFilter());
        this.addAvailableToolsDragSupport();
    }

    protected Combo createProfileCombo(Composite availableToolsComposite) {
        this.profileCombo = new Combo(availableToolsComposite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.profileCombo.setLayoutData((Object)data);
        List<Profile> profiles = this.getAllAppliedProfiles();
        int profileNumber = profiles.size();
        int i = 0;
        while (i < profileNumber) {
            this.profileComboList.add(i, profiles.get(i).getName());
            ++i;
        }
        this.profileComboList.add(UML_TOOLS_LABEL);
        this.profileCombo.setItems(this.profileComboList.toArray(new String[0]));
        ProfileComboSelectionListener listener = new ProfileComboSelectionListener();
        this.profileCombo.addSelectionListener((SelectionListener)listener);
        this.profileCombo.addModifyListener((ModifyListener)listener);
        return this.profileCombo;
    }

    protected List<Profile> getAllAppliedProfiles() {
        EObject element;
        Package topPackage = null;
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette && (element = ((DiagramEditorWithFlyOutPalette)this.editorPart).getDiagram().getElement()) instanceof Element) {
            topPackage = ((Element)element).getNearestPackage();
        }
        if (topPackage != null) {
            return topPackage.getAllAppliedProfiles();
        }
        return Collections.EMPTY_LIST;
    }

    protected void addAvailableToolsDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                event.data = ExtendedPaletteContentPage.this.availableToolsViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
                LocalSelectionTransfer.getTransfer().setSelection(ExtendedPaletteContentPage.this.availableToolsViewer.getSelection());
            }
        };
        this.availableToolsViewer.addDragSupport(4, transfers, (DragSourceListener)listener);
    }

    protected void populateAvailableToolsToolBar(ToolBar toolbar) {
        this.toggleContentProvider = this.createCheckToolBarItem(toolbar, this.SWITCH_CONTENT_PROVIDER_ICON, Messages.Local_Palette_SwitchToolsContentProvider_Tooltip, this.createSwitchToolsContentProviderListener());
        this.toggleContentProvider.setSelection(true);
        this.toggleContentProvider.setEnabled(false);
        this.createCheckToolBarItem(toolbar, SHOWN_TOOLS_ICON, Messages.Local_Palette_ShowTools_Tooltip, this.createsShowToolListener());
    }

    protected Listener createSwitchToolsContentProviderListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                int index = ExtendedPaletteContentPage.this.profileCombo.getSelectionIndex();
                Collection<PaletteEntry> standardEntries = ExtendedPaletteContentPage.this.getAllVisibleStandardEntries();
                Profile profile = ExtendedPaletteContentPage.this.getAllAppliedProfiles().get(index);
                if (item.getSelection()) {
                    ExtendedPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                    item.setSelection(true);
                } else {
                    ExtendedPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                    item.setSelection(false);
                }
                ExtendedPaletteContentPage.this.availableToolsViewer.setInput((Object)profile);
            }
        };
    }

    protected Listener createShowDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                if (item.getSelection()) {
                    ExtendedPaletteContentPage.this.availableToolsViewer.addFilter(ExtendedPaletteContentPage.this.drawerFilter);
                    item.setSelection(true);
                } else {
                    ExtendedPaletteContentPage.this.availableToolsViewer.removeFilter(ExtendedPaletteContentPage.this.drawerFilter);
                    item.setSelection(false);
                }
            }
        };
    }

    protected Listener createsShowToolListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                if (item.getSelection()) {
                    ExtendedPaletteContentPage.this.availableToolsViewer.addFilter(ExtendedPaletteContentPage.this.toolFilter);
                    item.setSelection(true);
                } else {
                    ExtendedPaletteContentPage.this.availableToolsViewer.removeFilter(ExtendedPaletteContentPage.this.toolFilter);
                    item.setSelection(false);
                }
            }
        };
    }

    protected ToolItem createCheckToolBarItem(ToolBar toolbar, String shownElementsIcon, String tooltip, Listener listener) {
        ToolItem item = new ToolItem(toolbar, 2080);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (String)shownElementsIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        return item;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public void performFinish(String path) {
        if (this.resourceToEdit != null) {
            try {
                this.resourceToEdit.save(Collections.emptyMap());
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected Collection<PaletteEntry> getAllVisibleStandardEntries() {
        HashSet<PaletteEntry> result = new HashSet<PaletteEntry>();
        for (PaletteEntry entry : PaletteUtil.getAvailableEntriesSet((IEditorPart)this.editorPart, (ProviderPriority)this.priority).values()) {
            if (this.getRootParent(entry) == null) continue;
            result.add(entry);
        }
        return result;
    }

    protected PaletteRoot getRootParent(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        if (parent instanceof PaletteRoot) {
            return (PaletteRoot)parent;
        }
        if (parent != null) {
            return this.getRootParent((PaletteEntry)parent);
        }
        return null;
    }

    protected class ConfigurationSelectedValidator
    extends ToolBarItemValidator {
        protected ConfigurationSelectedValidator() {
        }

        public boolean isEnable() {
            return ExtendedPaletteContentPage.this.getSelectedConfiguration() != null;
        }
    }

    protected class DrawerConfigurationSelectedValidator
    extends ToolBarItemValidator {
        protected DrawerConfigurationSelectedValidator() {
        }

        public boolean isEnable() {
            return ExtendedPaletteContentPage.this.getSelectedConfiguration() instanceof DrawerConfiguration;
        }
    }

    public class DrawerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof PaletteDrawer);
        }
    }

    public class ExtendedPaletteContentProvider
    extends CustomizableModelContentProvider {
        public ExtendedPaletteContentProvider() {
            super(ExtendedPaletteContentPage.this.manager);
            MetamodelView paletteCustomization = CustomizationsCatalog.getInstance().getCustomization("PaletteConfiguration");
            if (paletteCustomization != null) {
                ExtendedPaletteContentPage.this.manager.setShowTypeOfLinks(false);
                ExtendedPaletteContentPage.this.manager.registerCustomization(paletteCustomization);
                ExtendedPaletteContentPage.this.manager.loadCustomizations();
            }
        }

        public Object[] getRootElements(Object inputElement) {
            EObject rootObject;
            EList roots;
            if (inputElement instanceof PaletteConfiguration) {
                return ((PaletteConfiguration)inputElement).getDrawerConfigurations().toArray();
            }
            if (inputElement instanceof Resource && (roots = ((Resource)inputElement).getContents()) != null && !roots.isEmpty() && (rootObject = (EObject)roots.get(0)) instanceof PaletteConfiguration) {
                return ((PaletteConfiguration)rootObject).getDrawerConfigurations().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            if (children == null) {
                return false;
            }
            return children.length != 0;
        }
    }

    public class ExtendedPaletteLabelProvider
    extends CustomizableModelLabelProvider {
        public ExtendedPaletteLabelProvider() {
            super(ExtendedPaletteContentPage.this.manager);
        }
    }

    public class LabelViewerComparator
    extends ViewerComparator {
        public int compare(Viewer testViewer, Object e1, Object e2) {
            String label1 = "";
            String label2 = "";
            if (e1 instanceof PaletteEntry) {
                label1 = ((PaletteEntry)e1).getLabel();
            } else if (e1 instanceof Stereotype) {
                label1 = ((Stereotype)e1).getName();
            }
            if (e2 instanceof PaletteEntry) {
                label2 = ((PaletteEntry)e2).getLabel();
            } else if (e2 instanceof Stereotype) {
                label2 = ((Stereotype)e2).getName();
            }
            if (label1 == null) {
                return 1;
            }
            if (label2 == null) {
                return -1;
            }
            return label1.compareTo(label2);
        }
    }

    public class PaletteLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof PaletteEntry) {
                ImageDescriptor descriptor = ((PaletteEntry)element).getSmallIcon();
                if (descriptor == null) {
                    return null;
                }
                return Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (ImageDescriptor)descriptor);
            }
            if (element instanceof Stereotype) {
                return Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/stereotype.gif");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof PaletteEntry) {
                return ((PaletteEntry)element).getLabel();
            }
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getName();
            }
            return "unknown element";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ProfileComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelectionChanged();
        }

        public void modifyText(ModifyEvent e) {
            this.handleSelectionChanged();
        }

        protected void handleSelectionChanged() {
            int index = ExtendedPaletteContentPage.this.profileCombo.getSelectionIndex();
            if (index < 0 || index >= ExtendedPaletteContentPage.this.profileCombo.getItems().length) {
                return;
            }
            String name = ExtendedPaletteContentPage.this.profileComboList.get(index);
            Collection<PaletteEntry> standardEntries = ExtendedPaletteContentPage.this.getAllVisibleStandardEntries();
            if (ExtendedPaletteContentPage.UML_TOOLS_LABEL.equals(name)) {
                ExtendedPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
                ExtendedPaletteContentPage.this.availableToolsViewer.setInput(standardEntries);
                ExtendedPaletteContentPage.this.toggleContentProvider.setEnabled(false);
            } else {
                if (ExtendedPaletteContentPage.this.toggleContentProvider != null && !ExtendedPaletteContentPage.this.toggleContentProvider.isDisposed()) {
                    ExtendedPaletteContentPage.this.toggleContentProvider.setEnabled(true);
                }
                Profile profile = ExtendedPaletteContentPage.this.getAllAppliedProfiles().get(index);
                if (ExtendedPaletteContentPage.this.toggleContentProvider.getSelection()) {
                    ExtendedPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                } else {
                    ExtendedPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                }
                ExtendedPaletteContentPage.this.availableToolsViewer.setInput((Object)profile);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfileToolsMetaclassStereotypeTreeContentProvider
    implements ITreeContentProvider {
        protected final Collection<PaletteEntry> standardEntries;
        protected final Profile profile;

        public ProfileToolsMetaclassStereotypeTreeContentProvider(Profile profile, Collection<PaletteEntry> standardEntries) {
            this.profile = profile;
            this.standardEntries = standardEntries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                return this.standardEntries.toArray();
            }
            if (parentElement instanceof AspectCreationEntry) {
                return new Object[0];
            }
            if (parentElement instanceof PaletteEntry) {
                CombinedTemplateCreationEntry entry;
                EClass toolMetaclass;
                ArrayList<AspectCreationEntry> entries = new ArrayList<AspectCreationEntry>();
                if (parentElement instanceof CombinedTemplateCreationEntry && (toolMetaclass = PaletteUtil.getToolMetaclass((ToolEntry)(entry = (CombinedTemplateCreationEntry)parentElement))) != null) {
                    for (Stereotype stereotype : this.profile.getOwnedStereotypes()) {
                        EList metaclasses = stereotype.getAllExtendedMetaclasses();
                        for (Class stMetaclass : metaclasses) {
                            EClassifier metaClassifier;
                            java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                            if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(toolMetaclass)) continue;
                            HashMap<String, NodeList> properties = new HashMap<String, NodeList>();
                            ArrayList stereotypesQNToApply = new ArrayList();
                            properties.put("aspectActions", StereotypeAspectActionProvider.createConfigurationNode((String)stereotype.getQualifiedName()));
                            AspectCreationEntry aspectEntry = new AspectCreationEntry(String.valueOf(stereotype.getName()) + " (" + entry.getLabel() + ")", "Create an element with a stereotype", String.valueOf(entry.getId()) + "_" + System.currentTimeMillis(), entry.getSmallIcon(), entry, properties);
                            entries.add(aspectEntry);
                        }
                    }
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getProfile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                return true;
            }
            if (element instanceof AspectCreationEntry) {
                return false;
            }
            return element instanceof PaletteEntry;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Profile) {
                return this.standardEntries.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfileToolsStereotypeMetaclassTreeContentProvider
    implements ITreeContentProvider {
        protected final Collection<PaletteEntry> standardEntries;

        public ProfileToolsStereotypeMetaclassTreeContentProvider(Profile profile, Collection<PaletteEntry> standardEntries) {
            this.standardEntries = standardEntries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                return ((Profile)parentElement).getOwnedStereotypes().toArray();
            }
            if (parentElement instanceof Stereotype) {
                ArrayList<AspectCreationEntry> entries = new ArrayList<AspectCreationEntry>();
                Stereotype stereotype = (Stereotype)parentElement;
                for (PaletteEntry entry : this.standardEntries) {
                    EClass toolMetaclass;
                    if (!(entry instanceof CombinedTemplateCreationEntry) || (toolMetaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entry))) == null) continue;
                    EList metaclasses = stereotype.getAllExtendedMetaclasses();
                    for (Class stMetaclass : metaclasses) {
                        EClassifier metaClassifier;
                        java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                        if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(toolMetaclass)) continue;
                        HashMap<String, NodeList> properties = new HashMap<String, NodeList>();
                        properties.put("aspectActions", StereotypeAspectActionProvider.createConfigurationNode((String)stereotype.getQualifiedName()));
                        AspectCreationEntry aspectEntry = new AspectCreationEntry(String.valueOf(stereotype.getName()) + " (" + entry.getLabel() + ")", "Create an element with a stereotype", String.valueOf(entry.getId()) + "_" + System.currentTimeMillis(), entry.getSmallIcon(), (CombinedTemplateCreationEntry)entry, properties);
                        entries.add(aspectEntry);
                    }
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getProfile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                return true;
            }
            return element instanceof Stereotype;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Profile) {
                EList stereotypes = ((Profile)inputElement).getOwnedStereotypes();
                return stereotypes.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected abstract class ToolBarItemValidator {
        protected ToolBarItemValidator() {
        }

        public abstract boolean isEnable();
    }

    public class ToolFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof ToolEntry);
        }
    }

    public class UMLToolsTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof Collection) {
                elements = ((Collection)inputElement).toArray();
            } else if (inputElement instanceof PaletteRoot) {
                elements = PaletteUtil.getAllToolEntries((PaletteContainer)((PaletteRoot)inputElement)).toArray();
            }
            if (elements == null) {
                elements = new Object[]{};
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] elements = null;
            if (parentElement instanceof Collection) {
                elements = ((Collection)parentElement).toArray();
            } else if (parentElement instanceof PaletteRoot) {
                elements = PaletteUtil.getAllToolEntries((PaletteContainer)((PaletteRoot)parentElement)).toArray();
            }
            return elements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }
    }
}

