/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.dialog;

import java.util.Arrays;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.Messages;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.LocalPaletteContentPage;
import org.eclipse.papyrus.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;

public class LocalPaletteInformationPage
extends WizardPage
implements Listener {
    private static String[] priorityList = new String[]{ProviderPriority.LOWEST.getName(), ProviderPriority.LOW.getName(), ProviderPriority.MEDIUM.getName(), ProviderPriority.HIGH.getName(), ProviderPriority.HIGHEST.getName()};
    protected Text nameText;
    protected Text idText;
    protected Text editorText;
    private Combo priorityCombo;
    protected Composite advancedComposite;
    protected Button advancedButton;
    protected IEditorPart editorPart;
    protected ProviderPriority priority;
    protected String editorID;
    protected String paletteID;
    protected String name;
    protected static final String WIZARD_ICON = "/icons/local_desc_wiz.png";
    protected boolean validateOnLaunch = false;

    public LocalPaletteInformationPage(IEditorPart part) {
        super(Messages.Local_Palette_InfoPage_Name, Messages.Local_Palette_InfoPage_Title, Activator.getImageDescriptor((String)WIZARD_ICON));
        this.editorPart = part;
    }

    public IWizardPage getNextPage() {
        LocalPaletteContentPage contentPage = (LocalPaletteContentPage)super.getNextPage();
        if (this.priority != null) {
            contentPage.setPriority(this.priority);
            contentPage.profileCombo.deselectAll();
            contentPage.profileCombo.select(contentPage.profileCombo.getItems().length - 1);
        }
        return contentPage;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.createNameControl(control);
        this.createAdvancedControls(control);
        Dialog.applyDialogFont((Control)control);
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.validateOnLaunch) {
            this.setPageComplete(this.validatePage());
        }
        this.setControl((Control)control);
    }

    public void intializeValues() {
        this.initName("");
        String editorIDValue = "";
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette) {
            editorIDValue = ((DiagramEditorWithFlyOutPalette)this.editorPart).getContributorId();
        }
        this.initEditorID(editorIDValue);
        this.initPaletteID(String.valueOf(System.getProperty("user.name")) + "_" + System.currentTimeMillis());
        this.initPriority(ProviderPriority.MEDIUM);
    }

    public void intializeValues(PapyrusPaletteService.LocalProviderDescriptor descriptor) {
        this.initName(descriptor.getContributionName());
        String editorIDValue = "";
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette) {
            editorIDValue = ((DiagramEditorWithFlyOutPalette)this.editorPart).getContributorId();
        }
        this.initEditorID(editorIDValue);
        this.initPaletteID(descriptor.getContributionID());
        this.initPriority(PapyrusPalettePreferences.getPalettePriority((String)descriptor.getContributionID()));
        this.validateOnLaunch = true;
    }

    public String getPaletteName() {
        return this.name;
    }

    public String getPaletteID() {
        return this.paletteID;
    }

    public String getEditorID() {
        return this.editorID;
    }

    public ProviderPriority getPalettePriority() {
        return this.priority;
    }

    protected void initName(String value) {
        this.name = value;
    }

    protected void initPriority(ProviderPriority value) {
        this.priority = value;
    }

    protected void initPaletteID(String value) {
        this.paletteID = value;
    }

    protected void initEditorID(String value) {
        this.editorID = value;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (this.advancedComposite != null && !this.advancedComposite.isDisposed()) {
            if (-1 == this.priorityCombo.getSelectionIndex()) {
                this.setErrorMessage(Messages.Local_Palette_Error_Priority);
                valid = false;
            }
            if ("".equals(this.getEditorID())) {
                this.setErrorMessage(Messages.Local_Palette_Error_EditorId);
                valid = false;
            }
            if ("".equals(this.getPaletteID())) {
                this.setErrorMessage(Messages.Local_Palette_Error_PaletteId);
                valid = false;
            }
        }
        if ("".equals(this.getPaletteName())) {
            this.setErrorMessage(Messages.Local_Palette_Error_Name);
            valid = false;
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    protected void createAdvancedControls(Composite parent) {
        this.advancedButton = new Button(parent, 8);
        this.advancedButton.setFont(parent.getFont());
        this.advancedButton.setText(Messages.Dialog_Advanced_Button_Closed);
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        data.horizontalSpan = 2;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPaletteInformationPage.this.handleAdvancedButtonSelect();
            }
        });
    }

    public Composite createAdvancedComposite(Composite parent) {
        this.advancedComposite = new Composite(parent, 0);
        this.advancedComposite.setFont(parent.getFont());
        this.advancedComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.advancedComposite.setLayout((Layout)layout);
        this.createIDControl(this.advancedComposite);
        this.createEditorIDControl(this.advancedComposite);
        this.createPriorityControl(this.advancedComposite);
        this.advancedComposite.getParent().layout();
        return this.advancedComposite;
    }

    protected void handleAdvancedButtonSelect() {
        Composite composite = (Composite)this.getControl();
        if (this.advancedComposite != null) {
            this.advancedComposite.dispose();
            this.advancedComposite = null;
            this.advancedButton.setText(Messages.Dialog_Advanced_Button_Closed);
        } else {
            this.createAdvancedComposite(composite);
            this.advancedButton.setText(Messages.Dialog_Advanced_Button_Opened);
        }
    }

    protected void createPriorityControl(Composite control) {
        Label priorityLabel = new Label(control, 0);
        priorityLabel.setText(Messages.Local_Palette_Priority);
        priorityLabel.setToolTipText(Messages.Local_Palette_Priority_Tooltip);
        this.priorityCombo = new Combo(control, 8);
        this.priorityCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.priorityCombo.setToolTipText(Messages.Local_Palette_Priority_Tooltip);
        this.priorityCombo.setItems(priorityList);
        this.initialPopulatePriorityField();
        this.priorityCombo.addListener(24, (Listener)this);
    }

    protected void initialPopulatePriorityField() {
        this.priorityCombo.select(Arrays.asList(priorityList).indexOf(this.priority.getName()));
    }

    protected void createIDControl(Composite control) {
        Label idLabel = new Label(control, 0);
        idLabel.setText(Messages.Local_Palette_Id);
        idLabel.setToolTipText(Messages.Local_Palette_Id_Tooltip);
        this.idText = new Text(control, 2048);
        this.idText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.idText.setToolTipText(Messages.Local_Palette_Id_Tooltip);
        this.initialPopulatePaletteIDField();
        this.idText.addListener(24, (Listener)this);
    }

    protected void initialPopulatePaletteIDField() {
        this.idText.setText(this.paletteID);
    }

    protected void createNameControl(Composite control) {
        Label nameLabel = new Label(control, 0);
        nameLabel.setText(Messages.Local_Palette_Name);
        nameLabel.setToolTipText(Messages.Local_Palette_Name_Tooltip);
        this.nameText = new Text(control, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setToolTipText(Messages.Local_Palette_Name_Tooltip);
        this.initialPopulateNameField();
        this.nameText.addListener(24, (Listener)this);
    }

    protected void createEditorIDControl(Composite control) {
        Label editorLabel = new Label(control, 0);
        editorLabel.setText(Messages.Local_Palette_Editor_Id);
        editorLabel.setToolTipText(Messages.Local_Palette_Editor_Id_Tooltip);
        this.editorText = new Text(control, 2048);
        this.editorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.editorText.setToolTipText(Messages.Local_Palette_Editor_Id_Tooltip);
        this.initialPopulateEditorIDField();
        this.editorText.addListener(24, (Listener)this);
    }

    protected void initialPopulateEditorIDField() {
        this.editorText.setText(this.editorID);
    }

    protected void initialPopulateNameField() {
        this.nameText.setText(this.name);
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget.equals(this.nameText)) {
            this.name = this.nameText.getText();
        } else if (widget.equals(this.idText)) {
            this.paletteID = this.idText.getText();
        } else if (widget.equals(this.editorText)) {
            this.editorID = this.editorText.getText();
        } else if (widget.equals(this.priorityCombo)) {
            this.priority = ProviderPriority.parse((String)this.priorityCombo.getText());
        }
        this.setPageComplete(this.validatePage());
    }
}

