/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.dialog;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.LocalPaletteContentPage;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteContainerProxy;
import org.eclipse.papyrus.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteEntryProxy
implements IPaletteEntryProxy {
    public static final String PROPERTY_ICON_PATH = "ICON_PATH";
    public static final String PROPERTY_ADD_CHILDREN = "PROPERTY_ADD_CHILDREN";
    public static final String PROPERTY_REMOVE_CHILDREN = "PROPERTY_REMOVE_CHILDREN";
    private final PaletteEntry entry;
    private PaletteContainerProxy parent;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private LocalPaletteContentPage.EntryType type;

    public PaletteEntryProxy(PaletteEntry entry) {
        this.entry = entry;
        this.setType(this.initType());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public PaletteEntry getEntry() {
        return this.entry;
    }

    protected LocalPaletteContentPage.EntryType initType() {
        if (this.entry instanceof PaletteDrawer) {
            return LocalPaletteContentPage.EntryType.DRAWER;
        }
        if (this.entry instanceof PaletteSeparator) {
            return LocalPaletteContentPage.EntryType.SEPARATOR;
        }
        if (this.entry instanceof PaletteStack) {
            return LocalPaletteContentPage.EntryType.STACK;
        }
        if (this.entry instanceof AspectCreationEntry) {
            return LocalPaletteContentPage.EntryType.ASPECT_TOOL;
        }
        if (this.entry instanceof ToolEntry) {
            return LocalPaletteContentPage.EntryType.TOOL;
        }
        return LocalPaletteContentPage.EntryType.TOOL;
    }

    public String getLabel() {
        return this.entry.getLabel();
    }

    public String getId() {
        return this.entry.getId();
    }

    public Image getImage() {
        return Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.common", (ImageDescriptor)this.entry.getSmallIcon());
    }

    public String getDescription() {
        return this.entry != null ? this.entry.getDescription() : "";
    }

    public String getImagePath() {
        return "";
    }

    public void setParent(PaletteContainerProxy newParent) {
        this.parent = newParent;
    }

    public PaletteContainerProxy getParent() {
        return this.parent;
    }

    public List<PaletteEntryProxy> getChildren() {
        return null;
    }

    public void setType(LocalPaletteContentPage.EntryType type) {
        this.type = type;
    }

    public LocalPaletteContentPage.EntryType getType() {
        return this.type;
    }

    public void setDescription(String desc) {
        if (this.getEntry() == null) {
            return;
        }
        String oldDesc = this.getEntry().getDescription();
        if (oldDesc == null && desc == null) {
            return;
        }
        if (desc == null || !desc.equals(oldDesc)) {
            this.getEntry().setDescription(desc);
            this.listeners.firePropertyChange("Description", oldDesc, desc);
        }
    }

    public void setLabel(String label) {
        if (this.getEntry() == null) {
            return;
        }
        String oldLabel = this.getEntry().getLabel();
        if (oldLabel == null && label == null) {
            return;
        }
        if (label == null || !label.equals(oldLabel)) {
            this.getEntry().setLabel(label);
            this.listeners.firePropertyChange("Name", oldLabel, label);
        }
    }

    public void setIcon(String path) {
        if (!(this.getEntry() instanceof AspectCreationEntry)) {
            return;
        }
        String oldPath = ((AspectCreationEntry)this.getEntry()).getIconPath();
        if (oldPath == null && path == null) {
            return;
        }
        if (path == null || !path.equals(oldPath)) {
            ((AspectCreationEntry)this.getEntry()).setIconPath(path);
            this.listeners.firePropertyChange(PROPERTY_ICON_PATH, oldPath, path);
        }
    }

    protected void addChild(PaletteEntryProxy entry) {
        this.listeners.firePropertyChange(PROPERTY_ADD_CHILDREN, null, entry);
    }

    protected void addChild(PaletteEntryProxy entry, PaletteEntryProxy nextElement) {
        this.listeners.firePropertyChange(PROPERTY_ADD_CHILDREN, null, entry);
    }

    public void removeChild(PaletteEntryProxy proxy) {
        this.listeners.firePropertyChange(PROPERTY_REMOVE_CHILDREN, proxy, null);
    }
}

