/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.dialog;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.Messages;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.BundleIconExplorerDialog;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.LocalPaletteContentPage;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteAspectToolEntryProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.diagram.common.part.PaletteUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteEntryProxyInformationComposite {
    protected PaletteEntryProxy selectedEntryProxy;
    protected Text nameText;
    protected Text descriptionText;
    protected Text iconText;
    protected Text referencedText;
    protected List<Profile> appliedProfiles;
    protected Button iconButton;

    public Composite createComposite(final Composite parent, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 260;
        data.horizontalIndent = 10;
        composite.setLayoutData((Object)data);
        Label entryInformationLabel = new Label(composite, 0);
        entryInformationLabel.setText(Messages.Local_Palette_Entry_Information);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        entryInformationLabel.setLayoutData((Object)data);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.Local_Palette_Entry_Name);
        data = new GridData(4, 4, false, false);
        nameLabel.setLayoutData((Object)data);
        this.nameText = new Text(composite, 18432);
        data = new GridData(4, 4, true, false);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addFocusListener((FocusListener)new NameFocusListener());
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)data);
        Label referencedLabel = new Label(composite, 0);
        referencedLabel.setText(Messages.Local_Palette_Entry_Reference);
        data = new GridData(4, 1, true, false);
        referencedLabel.setLayoutData((Object)data);
        this.referencedText = new Text(composite, 18440);
        data = new GridData(4, 4, true, false);
        this.referencedText.setLayoutData((Object)data);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.referencedText.setLayoutData((Object)data);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.Local_Palette_Entry_Description);
        data = new GridData(4, 1, true, false);
        descriptionLabel.setLayoutData((Object)data);
        this.descriptionText = new Text(composite, 2112);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.widthHint = 160;
        this.descriptionText.setLayoutData((Object)data);
        this.descriptionText.addFocusListener((FocusListener)new DescriptionFocusListener());
        Label iconLabel = new Label(composite, 0);
        iconLabel.setText(Messages.Local_Palette_Entry_Icon);
        data = new GridData(4, 1, true, false);
        iconLabel.setLayoutData((Object)data);
        this.iconText = new Text(composite, 18432);
        data = new GridData(4, 4, true, false);
        this.iconText.setLayoutData((Object)data);
        this.iconText.addFocusListener((FocusListener)new IconFocusListener());
        this.iconButton = new Button(composite, 0);
        this.iconButton.setText("Select...");
        this.iconButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                BundleIconExplorerDialog dialog = new BundleIconExplorerDialog(parent.getShell(), PaletteEntryProxyInformationComposite.this.iconText.getText());
                if (dialog.open() == 0) {
                    Object[] values = dialog.getResult();
                    if (values.length != 1) {
                        Activator.log.error("Waiting one icon path, but found " + values.length, null);
                    } else {
                        PaletteEntryProxyInformationComposite.this.iconText.setText(values[0].toString());
                        PaletteEntryProxyInformationComposite.this.selectedEntryProxy.getEntry().setSmallIcon(Activator.getImageDescriptor((String)PaletteEntryProxyInformationComposite.this.iconText.getText().trim()));
                        PaletteEntryProxyInformationComposite.this.selectedEntryProxy.getEntry().setLargeIcon(Activator.getImageDescriptor((String)PaletteEntryProxyInformationComposite.this.iconText.getText().trim()));
                        if (PaletteEntryProxyInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
                            ((PaletteAspectToolEntryProxy)PaletteEntryProxyInformationComposite.this.selectedEntryProxy).setIcon(PaletteEntryProxyInformationComposite.this.iconText.getText().trim());
                        }
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return composite;
    }

    protected void updateNameEntryField() {
        LocalPaletteContentPage.EntryType type = this.selectedEntryProxy.getType();
        switch (type) {
            case STACK: 
            case SEPARATOR: {
                this.nameText.setText("");
                this.nameText.setEnabled(false);
                break;
            }
            case DRAWER: 
            case TOOL: 
            case ASPECT_TOOL: {
                String name = this.selectedEntryProxy.getLabel();
                this.nameText.setText(name != null ? name : "");
                this.nameText.setEnabled(true);
            }
        }
    }

    protected void updateReferencedEntryField() {
        if (this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
            CombinedTemplateCreationEntry entry = ((PaletteAspectToolEntryProxy)this.selectedEntryProxy).getEntry().getReferencedEntry();
            EClass eClass = PaletteUtil.getToolMetaclass((ToolEntry)entry);
            this.referencedText.setText(eClass != null ? eClass.getInstanceTypeName() : "");
        } else if (this.selectedEntryProxy instanceof PaletteEntryProxy) {
            PaletteEntry entry = this.selectedEntryProxy.getEntry();
            if (entry instanceof CombinedTemplateCreationEntry) {
                EClass eClass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entry));
                this.referencedText.setText(eClass != null ? eClass.getInstanceTypeName() : "");
            } else {
                this.referencedText.setText("");
            }
        } else {
            this.referencedText.setText("");
        }
    }

    protected void updateDescriptionEntryField() {
        LocalPaletteContentPage.EntryType type = this.selectedEntryProxy.getType();
        switch (type) {
            case DRAWER: 
            case STACK: 
            case SEPARATOR: {
                this.descriptionText.setText("");
                this.descriptionText.setEnabled(false);
                break;
            }
            case TOOL: 
            case ASPECT_TOOL: {
                String name = this.selectedEntryProxy.getDescription();
                this.descriptionText.setText(name != null ? name : "");
                this.descriptionText.setEnabled(true);
            }
        }
    }

    protected void updateIconEntryField() {
        LocalPaletteContentPage.EntryType type = this.selectedEntryProxy.getType();
        switch (type) {
            case TOOL: 
            case STACK: 
            case SEPARATOR: {
                this.iconText.setText("");
                this.iconText.setEnabled(false);
                this.iconButton.setEnabled(false);
                break;
            }
            case DRAWER: {
                String drawerIcon = this.selectedEntryProxy.getImagePath();
                this.iconText.setText(drawerIcon != null ? drawerIcon : "");
                this.iconText.setEnabled(false);
                this.iconButton.setEnabled(false);
                break;
            }
            case ASPECT_TOOL: {
                String icon = this.selectedEntryProxy.getImagePath();
                this.iconText.setText(icon != null ? icon : "");
                this.iconText.setEnabled(true);
                this.iconButton.setEnabled(true);
            }
        }
    }

    public void setSelectedEntryProxy(PaletteEntryProxy selectedEntryProxy) {
        this.selectedEntryProxy = selectedEntryProxy;
        this.updateNameEntryField();
        this.updateIconEntryField();
        this.updateReferencedEntryField();
        this.updateDescriptionEntryField();
    }

    protected class DescriptionFocusListener
    implements FocusListener {
        protected DescriptionFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (PaletteEntryProxyInformationComposite.this.selectedEntryProxy != null && PaletteEntryProxyInformationComposite.this.selectedEntryProxy.getEntry() != null) {
                PaletteEntryProxyInformationComposite.this.selectedEntryProxy.setDescription(PaletteEntryProxyInformationComposite.this.descriptionText.getText().trim());
            }
        }
    }

    protected class IconFocusListener
    implements FocusListener {
        protected IconFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (PaletteEntryProxyInformationComposite.this.selectedEntryProxy != null && PaletteEntryProxyInformationComposite.this.iconText.getText() != null && !PaletteEntryProxyInformationComposite.this.iconText.getText().equals("")) {
                PaletteEntryProxyInformationComposite.this.selectedEntryProxy.getEntry().setSmallIcon(Activator.getImageDescriptor((String)PaletteEntryProxyInformationComposite.this.iconText.getText().trim()));
                PaletteEntryProxyInformationComposite.this.selectedEntryProxy.getEntry().setLargeIcon(Activator.getImageDescriptor((String)PaletteEntryProxyInformationComposite.this.iconText.getText().trim()));
                if (PaletteEntryProxyInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
                    ((PaletteAspectToolEntryProxy)PaletteEntryProxyInformationComposite.this.selectedEntryProxy).setIcon(PaletteEntryProxyInformationComposite.this.iconText.getText().trim());
                }
            }
        }
    }

    protected class NameFocusListener
    implements FocusListener {
        protected NameFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (PaletteEntryProxyInformationComposite.this.selectedEntryProxy != null) {
                PaletteEntryProxyInformationComposite.this.selectedEntryProxy.setLabel(PaletteEntryProxyInformationComposite.this.nameText.getText().trim());
            }
        }
    }
}

