/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.dialog;

import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.ExtendedPaletteContentPage;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.ExtendedPaletteInformationPage;
import org.eclipse.papyrus.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.ui.IEditorPart;

public class UpdateExtendedPaletteWizard
extends Wizard {
    protected IEditorPart editorPart;
    protected ExtendedPaletteContentPage contentPage;
    protected ExtendedPaletteInformationPage infoPage;
    protected PapyrusPaletteService.ExtendedProviderDescriptor descriptor;
    private PaletteCustomizer customizer;

    public UpdateExtendedPaletteWizard(IEditorPart part, PapyrusPaletteService.ExtendedProviderDescriptor descriptor, PaletteCustomizer customizer) {
        this.editorPart = part;
        this.descriptor = descriptor;
        this.customizer = customizer;
    }

    public void addPages() {
        super.addPages();
        this.infoPage = new ExtendedPaletteInformationPage(this.editorPart);
        this.infoPage.intializeValues(this.descriptor);
        this.contentPage = new ExtendedPaletteContentPage(this.editorPart, this.customizer);
        this.contentPage.initializeContent(this.descriptor);
        this.addPage((IWizardPage)this.infoPage);
        this.addPage((IWizardPage)this.contentPage);
    }

    public boolean performFinish() {
        this.contentPage.performFinish(PapyrusPalettePreferences.getPalettePathFromID((String)this.infoPage.getPaletteID()));
        String path = PapyrusPalettePreferences.getPaletteRedefinition((String)this.infoPage.getPaletteID());
        PapyrusPalettePreferences.registerLocalRedefinition((String)this.infoPage.getPaletteID(), (String)path);
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette) {
            PapyrusPalettePreferences.changePaletteVisibility((String)this.infoPage.getPaletteID(), (IEditorPart)this.editorPart, (boolean)false);
            PapyrusPalettePreferences.changePaletteVisibility((String)this.infoPage.getPaletteID(), (IEditorPart)this.editorPart, (boolean)true);
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }
}

