/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.palette.customization.proxies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteAspectToolEntryProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteContainerProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteLocalDrawerProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteLocalSeparatorProxy;
import org.eclipse.papyrus.diagram.common.palette.customization.dialog.PaletteLocalStackProxy;
import org.eclipse.papyrus.diagram.common.service.AbstractXMLDefinitionPaletteFactory;
import org.eclipse.papyrus.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDefinitionPaletteProxyFactory
extends AbstractXMLDefinitionPaletteFactory
implements IPapyrusPaletteConstant {
    protected final Map<String, PaletteEntry> predefinedEntries;
    protected PaletteContainerProxy containerProxy;
    protected final Map<Node, IPaletteEntryProxy> registry;

    public XMLDefinitionPaletteProxyFactory(Map<String, PaletteEntry> predefinedEntries) {
        this.predefinedEntries = predefinedEntries;
        this.registry = new HashMap<Node, IPaletteEntryProxy>();
    }

    public void traverseContentNode(Node node) {
        this.containerProxy = new PaletteContainerProxy(null);
        this.registry.put(node, this.containerProxy);
    }

    public void traverseDrawerNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        Node descriptionNode = node.getAttributes().getNamedItem("description");
        PaletteLocalDrawerProxy proxy = new PaletteLocalDrawerProxy(node.getAttributes().getNamedItem("name").getNodeValue(), node.getAttributes().getNamedItem("id").getNodeValue(), node.getAttributes().getNamedItem("iconpath").getNodeValue(), descriptionNode != null ? descriptionNode.getNodeValue() : "");
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    protected PaletteContainerProxy getParentProxy(Node node) {
        return (PaletteContainerProxy)this.registry.get(node.getParentNode());
    }

    public void traverseSeparatorNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteLocalSeparatorProxy proxy = new PaletteLocalSeparatorProxy(id);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void traverseStackNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteLocalStackProxy proxy = new PaletteLocalStackProxy(id);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void traverseToolEntryNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        PaletteEntryProxy proxy = new PaletteEntryProxy(entry);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void traverseAspectToolEntryNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        if (entry instanceof AspectCreationEntry) {
            PaletteAspectToolEntryProxy proxy = new PaletteAspectToolEntryProxy((AspectCreationEntry)entry);
            this.getParentProxy(node).addChild(proxy);
            this.registry.put(node, proxy);
        } else {
            Activator.log.error("impossible to log class " + id, null);
        }
    }

    public PaletteContainerProxy getRootProxy() {
        return this.containerProxy;
    }
}

