/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.providers.EditorLabelProvider;
import org.eclipse.papyrus.diagram.common.util.ViewServiceUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShowHideAction
implements IActionDelegate,
IWorkbenchWindowActionDelegate {
    protected List<IGraphicalEditPart> selectedElements;
    protected List<Object> initialSelection;
    private String editPolicyKey = null;
    private String title = null;
    private String message = null;
    private ILabelProvider labelProvider = null;
    private ITreeContentProvider contentProvider = null;
    protected List<EditPartRepresentation> viewsToDestroy;
    protected List<EditPartRepresentation> viewsToCreate;
    protected List<EditPartRepresentation> representations;

    public AbstractShowHideAction(String title, String message, String editPolicyKey) {
        this.editPolicyKey = editPolicyKey;
        this.title = title;
        this.message = message;
        ViewServiceUtil.forceLoad();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (!this.canRun()) {
            return;
        }
        this.initAction();
        this.buildInitialSelection();
        SelectionDialog selectionDialog = this.getSelectionDialog();
        selectionDialog.open();
        if (selectionDialog.getReturnCode() == 0) {
            this.buildShowHideElementsList(selectionDialog.getResult());
            final org.eclipse.gef.commands.Command command = this.getActionCommand();
            final TransactionalEditingDomain domain = this.selectedElements.get(0).getEditingDomain();
            if (command.canExecute()) {
                try {
                    domain.runExclusive(new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(command));
                                }
                            });
                        }
                    });
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    protected SelectionDialog getSelectionDialog() {
        CheckedTreeSelectionDialog selectionDialog = new CheckedTreeSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), this.getEditorLabelProvider(), this.getContentProvider());
        selectionDialog.setTitle(this.title);
        selectionDialog.setMessage(this.message);
        selectionDialog.setContainerMode(true);
        selectionDialog.setInput(this.getInput());
        selectionDialog.setExpandedElements(this.getExpandedElements());
        selectionDialog.setInitialElementSelections(this.getInitialSelection());
        return selectionDialog;
    }

    protected Object[] getExpandedElements() {
        ArrayList<EditPartRepresentation> allElements = new ArrayList<EditPartRepresentation>();
        for (EditPartRepresentation current : this.representations) {
            allElements.add(current);
            allElements.addAll(current.getPossibleElement());
        }
        return allElements.toArray();
    }

    public boolean canRun() {
        if (this.selectedElements.isEmpty()) {
            return false;
        }
        for (IGraphicalEditPart object : this.selectedElements) {
            if (!(object instanceof EditPart)) {
                return false;
            }
            EditPolicy policy = ((EditPart)object).getEditPolicy((Object)this.editPolicyKey);
            if (policy != null) continue;
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        if (this.editPolicyKey != null) {
            this.selectedElements = new ArrayList<IGraphicalEditPart>();
            if (selection instanceof StructuredSelection) {
                Object[] objectArray = ((StructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof IGraphicalEditPart) {
                        this.selectedElements.add((IGraphicalEditPart)current);
                        EditPolicy policy = ((IGraphicalEditPart)current).getEditPolicy((Object)this.editPolicyKey);
                        if (policy != null) {
                            enabled = true;
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void initAction() {
        this.labelProvider = new EditPartRepresentationLabelProvider();
        this.representations = new ArrayList<EditPartRepresentation>();
    }

    public List<Object> getInitialSelection() {
        return this.initialSelection;
    }

    protected void buildInitialSelection() {
        this.initialSelection = new ArrayList<Object>();
        for (EditPartRepresentation current : this.representations) {
            this.contributeToInitialSelection(this.initialSelection, current);
        }
    }

    protected void contributeToInitialSelection(List<Object> listToComplete, EditPartRepresentation representation) {
        listToComplete.addAll(representation.getInitialSelection());
        List<EditPartRepresentation> children = representation.getPossibleElement();
        if (children != null) {
            for (EditPartRepresentation child : children) {
                this.contributeToInitialSelection(listToComplete, child);
            }
        }
    }

    protected abstract List<Object> getInput();

    protected void buildShowHideElementsList(Object[] result) {
        this.viewsToCreate = new ArrayList<EditPartRepresentation>();
        this.viewsToDestroy = new ArrayList<EditPartRepresentation>();
    }

    protected abstract org.eclipse.gef.commands.Command getActionCommand();

    protected void setEditorLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    protected ILabelProvider getEditorLabelProvider() {
        return this.labelProvider;
    }

    protected void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setSelection(List<IGraphicalEditPart> selection) {
        this.selectedElements = selection;
    }

    public String getEditPolicyKey() {
        return this.editPolicyKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EditPartRepresentation {
        private IGraphicalEditPart representedEditPart;
        protected List<EditPartRepresentation> initialSelection;
        protected List<EditPartRepresentation> elementsToSelect;
        protected EObject eObject;
        private final EditPartRepresentation parentRepresentation;

        public EditPartRepresentation(IGraphicalEditPart representedEditPart, EObject eObject) {
            this(representedEditPart, eObject, null);
        }

        public EditPartRepresentation(IGraphicalEditPart representedEditPart, EObject eObject, EditPartRepresentation parentRepresentation) {
            this.setRepresentedEditPart(representedEditPart);
            this.eObject = eObject;
            this.parentRepresentation = parentRepresentation;
            this.initRepresentation();
        }

        public IGraphicalEditPart getRepresentedEditPart() {
            return this.representedEditPart;
        }

        public EObject getSemanticElement() {
            return this.eObject;
        }

        public List<EditPartRepresentation> getInitialSelection() {
            return this.initialSelection;
        }

        protected void initRepresentation() {
            this.initialSelection = new ArrayList<EditPartRepresentation>();
            this.elementsToSelect = new ArrayList<EditPartRepresentation>();
        }

        public List<EditPartRepresentation> getPossibleElement() {
            return this.elementsToSelect;
        }

        public EditPartRepresentation getParentRepresentation() {
            return this.parentRepresentation;
        }

        public void setRepresentedEditPart(IGraphicalEditPart representedEditPart) {
            this.representedEditPart = representedEditPart;
        }

        public String getLabel() {
            EObject semanticElement = this.getSemanticElement();
            if (this.isElementInherited()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(AbstractShowHideAction.this.getEditorLabelProvider().getText((Object)this.getSemanticElement()));
                buffer.append(" ");
                buffer.append("(from ");
                buffer.append(AbstractShowHideAction.this.getEditorLabelProvider().getText((Object)this.getSemanticElement().eContainer()));
                buffer.append(")");
                return buffer.toString();
            }
            return AbstractShowHideAction.this.getEditorLabelProvider().getText((Object)semanticElement);
        }

        public Image getImage() {
            return AbstractShowHideAction.this.getEditorLabelProvider().getImage((Object)this.getSemanticElement());
        }

        protected boolean isElementInherited() {
            EditPartRepresentation parentRepresentation = this.getParentRepresentation();
            if (parentRepresentation == null) {
                return false;
            }
            if (this.getSemanticElement() == null) {
                return false;
            }
            EObject parentElement = parentRepresentation.getSemanticElement();
            EObject elementOwner = this.getSemanticElement().eContainer();
            if (parentElement == null || elementOwner == null) {
                return false;
            }
            return !parentElement.equals(elementOwner);
        }
    }

    protected class EditPartRepresentationLabelProvider
    extends LabelProvider {
        protected EditorLabelProvider editorLabelProvider = new EditorLabelProvider();

        public String getText(Object element) {
            if (element instanceof EditPartRepresentation) {
                return ((EditPartRepresentation)element).getLabel();
            }
            return this.editorLabelProvider.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof EditPartRepresentation) {
                return ((EditPartRepresentation)element).getImage();
            }
            return this.editorLabelProvider.getImage(element);
        }
    }
}

