/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.diagram.common.commands.AbstractCommonTransactionalCommmand;

public class AnnotateNodeStyleCommand
extends AbstractCommonTransactionalCommmand {
    public static final String COMMAND_LABEL = "Annotate Node Style Changes";
    public static final String APPEARANCE_EANNOTATION_NAME = "es.cv.gvcase.mdt.common.gmfextension.appearance";
    private IGraphicalEditPart editPart;
    private EAttribute eAttribute;

    public AnnotateNodeStyleCommand(IGraphicalEditPart ep, EAttribute attr, TransactionalEditingDomain domain, List affectedFiles) {
        this(ep, attr, domain, COMMAND_LABEL, affectedFiles);
    }

    public AnnotateNodeStyleCommand(IGraphicalEditPart ep, EAttribute attr, TransactionalEditingDomain domain, String commandLabel, List affectedFiles) {
        super(domain, commandLabel, affectedFiles);
        this.setEAttribute(attr);
        this.setEditPart(ep);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.addChangesToAppearenceEAnnotation(this.getEAttribute());
        return CommandResult.newOKCommandResult();
    }

    protected EAnnotation getAppearenceEAnnotation() {
        EAnnotation eAnn = this.getEditPart().getPrimaryView().getEAnnotation(APPEARANCE_EANNOTATION_NAME);
        return eAnn;
    }

    protected EAnnotation createAppearenceEAnnotation() {
        EAnnotation eAnn = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnn.setSource(APPEARANCE_EANNOTATION_NAME);
        this.getEditPart().getPrimaryView().getEAnnotations().add((Object)eAnn);
        return eAnn;
    }

    protected void addChangesToAppearenceEAnnotation(EAttribute attribute) {
        EAnnotation eAnn = this.getAppearenceEAnnotation();
        if (eAnn == null) {
            eAnn = this.createAppearenceEAnnotation();
        }
        if (eAnn.getReferences().contains((Object)attribute)) {
            return;
        }
        if (NotationPackage.eINSTANCE.getFillStyle_FillColor().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FILL_STYLE__FILL_COLOR);
        }
        if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.LINE_STYLE__LINE_COLOR);
        }
        if (NotationPackage.eINSTANCE.getFontStyle_FontName().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FONT_STYLE__FONT_NAME);
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FONT_STYLE__FONT_COLOR);
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT);
        } else if (NotationPackage.eINSTANCE.getFontStyle_Bold().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FONT_STYLE__BOLD);
        } else if (NotationPackage.eINSTANCE.getFontStyle_Italic().equals(attribute)) {
            eAnn.getReferences().add((Object)NotationPackage.Literals.FONT_STYLE__ITALIC);
        }
    }

    public IGraphicalEditPart getEditPart() {
        return this.editPart;
    }

    public EAttribute getEAttribute() {
        return this.eAttribute;
    }

    public void setEAttribute(EAttribute attribute) {
        this.eAttribute = attribute;
    }

    public void setEditPart(IGraphicalEditPart editPart) {
        this.editPart = editPart;
    }
}

