/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class ChangeZOrderOfCreatedEP
extends AbstractTransactionalCommand {
    private CreateViewRequest.ViewDescriptor viewDescriptor = null;
    private EditPartViewer viewer = null;
    private String requestString = "";

    public ChangeZOrderOfCreatedEP(TransactionalEditingDomain domain, CreateViewRequest.ViewDescriptor descriptor, EditPartViewer viewer, String reqString) {
        super(domain, "Change ZOrder of Created Node", null);
        this.viewDescriptor = descriptor;
        this.viewer = viewer;
        this.requestString = this.isAllowedReqString(reqString) ? reqString : "sendToBackAction";
    }

    private boolean isAllowedReqString(String reqString) {
        if ("sendToBackAction".equals(reqString)) {
            return true;
        }
        if ("sendBackwardAction".equals(reqString)) {
            return true;
        }
        if ("bringForwardAction".equals(reqString)) {
            return true;
        }
        return "bringToFrontAction".equals(reqString);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = (View)this.viewDescriptor.getAdapter(View.class);
        if (view == null) {
            return CommandResult.newErrorCommandResult((String)"Element view not created");
        }
        Command command = this.getZOrderCommand(view);
        if (command != null) {
            command.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    private Command getZOrderCommand(View view) {
        IGraphicalEditPart newElementEP = (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(view);
        newElementEP.getFigure().getUpdateManager().performUpdate();
        ZOrderRequest zOrderReq = new ZOrderRequest(this.requestString);
        ArrayList<IGraphicalEditPart> elements = new ArrayList<IGraphicalEditPart>();
        elements.add(newElementEP);
        zOrderReq.setPartsToOrder(elements);
        Command command = newElementEP.getParent().getCommand((Request)zOrderReq);
        return command;
    }
}

