/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class CreateElementAndInitializeFeatureCommand
extends Command {
    CompoundCommand compoundCommand = new CompoundCommand();
    private CreateElementCommand createElementCommand;
    private EReference featureToInitialize;
    private Object initializationValue;

    public CreateElementAndInitializeFeatureCommand(CreateElementCommand createCommand, EReference feature, Object value) {
        this.createElementCommand = createCommand;
        this.featureToInitialize = feature;
        this.initializationValue = value;
    }

    public boolean canExecute() {
        return this.createElementCommand != null && this.featureToInitialize != null && this.initializationValue != null;
    }

    public boolean canUndo() {
        return this.compoundCommand.canUndo();
    }

    public Command chain(Command command) {
        this.compoundCommand.chain(command);
        return this;
    }

    public void dispose() {
        this.compoundCommand.dispose();
        super.dispose();
    }

    public void execute() {
        try {
            this.createElementCommand.execute(null, null);
            this.compoundCommand.add((Command)new ICommandProxy((ICommand)this.createElementCommand));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EObject newElement = this.createElementCommand.getNewElement();
        SetRequest setRequest = new SetRequest(newElement, (EStructuralFeature)this.featureToInitialize, this.initializationValue);
        SetValueCommand setValueCommand = new SetValueCommand(setRequest);
        try {
            setValueCommand.execute(null, null);
            this.compoundCommand.add((Command)new ICommandProxy((ICommand)setValueCommand));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return;
        }
    }

    public String getDebugLabel() {
        return super.getDebugLabel();
    }

    public String getLabel() {
        return super.getLabel();
    }

    public void redo() {
        this.compoundCommand.redo();
    }

    public void setDebugLabel(String label) {
        super.setDebugLabel(label);
    }

    public void setLabel(String label) {
        super.setLabel(label);
    }

    public void undo() {
        this.compoundCommand.redo();
    }
}

