/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class DeferredCreateCommand
extends AbstractTransactionalCommand {
    private IAdaptable adapter;
    private EditPartViewer editPartViewer;
    private EObject parent;

    public DeferredCreateCommand(TransactionalEditingDomain domain, EObject parentEObject, IAdaptable parentAdapter, EditPartViewer editPartViewer) {
        super(domain, DiagramUIMessages.CreateCommand_Label, DeferredCreateCommand.getWorkspaceFiles((EObject)parentEObject));
        this.editPartViewer = editPartViewer;
        Assert.isNotNull((Object)parentAdapter);
        this.adapter = parentAdapter;
        this.parent = parentEObject;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = (View)this.adapter.getAdapter(View.class);
        if (view != null) {
            EditPart parentEditPart = (EditPart)this.editPartViewer.getEditPartRegistry().get(view.eContainer());
            parentEditPart.refresh();
            Object editPart = this.editPartViewer.getEditPartRegistry().get(view);
            ArrayList<IGraphicalEditPart> graphicalEditParts = new ArrayList<IGraphicalEditPart>();
            if (editPart != null && editPart instanceof IGraphicalEditPart) {
                IGraphicalEditPart graphicalParentEditPart = (IGraphicalEditPart)editPart;
                graphicalEditParts.add(graphicalParentEditPart);
                for (Object child : graphicalParentEditPart.getChildren()) {
                    if (!(child instanceof IGraphicalEditPart)) continue;
                    graphicalEditParts.add((IGraphicalEditPart)child);
                }
                for (Object child : this.parent.eContents()) {
                    boolean alreadyDisplay = false;
                    for (IGraphicalEditPart gep : graphicalEditParts) {
                        Command command;
                        DropObjectsRequest request = new DropObjectsRequest();
                        request.setObjects(Collections.singletonList(child));
                        request.setLocation(new Point(10, 10));
                        if (request.getExtendedData() != null) {
                            request.getExtendedData().put("EVENT_DETAIL", 1);
                        }
                        if ((command = gep.getCommand((Request)request)) == null || !command.canExecute() || alreadyDisplay) continue;
                        command.execute();
                        parentEditPart.refresh();
                        alreadyDisplay = true;
                        if (gep.getChildren() == null || gep.getChildren().isEmpty()) continue;
                        ArrangeRequest r = new ArrangeRequest("arrangeAllAction");
                        r.setPartsToArrange(gep.getChildren());
                        Command d = gep.getCommand((Request)r);
                        if (d == null || !d.canExecute()) continue;
                        d.execute();
                    }
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean canExecute() {
        return true;
    }
}

