/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNamedElementCommand
extends DuplicateEObjectsCommand {
    public static final String COPY_OF = "Copy_Of_";
    protected Object diagram;

    public DuplicateNamedElementCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated, Map allDuplicatedObjectsMap, Diagram currentDiagram) {
        super(editingDomain, label, eObjectsToBeDuplicated, allDuplicatedObjectsMap);
        this.diagram = currentDiagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        super.doExecuteWithResult(progressMonitor, info);
        ArrayList<NamedElement> processedData = new ArrayList<NamedElement>();
        NamedElement namedElement = null;
        for (Object o : this.getObjectsToBeDuplicated()) {
            Object currentObject = this.getAllDuplicatedObjectsMap().get(o);
            if (currentObject instanceof View) {
                if (((View)currentObject).getElement() == null || !(((View)currentObject).getElement() instanceof NamedElement) || processedData.contains(namedElement = (NamedElement)((View)currentObject).getElement())) continue;
                namedElement.setName(DuplicateNamedElementCommand.computeNewName(namedElement.getName(), (List<EObject>)namedElement.eContainer().eContents()));
                processedData.add(namedElement);
                continue;
            }
            if (!(currentObject instanceof NamedElement) || processedData.contains(namedElement = (NamedElement)currentObject)) continue;
            namedElement.setName(DuplicateNamedElementCommand.computeNewName(namedElement.getName(), (List<EObject>)namedElement.eContainer().eContents()));
            processedData.add(namedElement);
        }
        for (Object currentObject : this.getAllDuplicatedObjectsMap().values()) {
            if (!(currentObject instanceof EObject) || ((EObject)currentObject).eContainer() != null || ((EObject)currentObject).eResource() != null) continue;
            namedElement.eResource().getContents().add((Object)((EObject)currentObject));
        }
        return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
    }

    public static String computeNewName(String baseName, List<EObject> siblings) {
        int maxIndex;
        int max = 0;
        EObject maxObject = null;
        if (baseName == null) {
            return "";
        }
        if (siblings == null) {
            return baseName;
        }
        int lowIndex = baseName.startsWith(COPY_OF) ? COPY_OF.length() : 0;
        int tmp = baseName.lastIndexOf("_");
        if (tmp < (maxIndex = baseName.length()) && tmp > 0 && tmp >= lowIndex) {
            maxIndex = tmp;
        }
        String base = COPY_OF + baseName.substring(lowIndex, maxIndex) + "_";
        for (EObject o : siblings) {
            String name;
            if (o == null || (name = EMFCoreUtil.getName((EObject)o)) == null || !name.startsWith(base)) continue;
            String end = name.substring(base.length());
            int nextNumberTmp = 1;
            if (end != null && end.length() > 0) {
                try {
                    nextNumberTmp = Integer.parseInt(end);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nextNumberTmp <= max || o.equals(maxObject)) continue;
            max = nextNumberTmp;
            maxObject = o;
        }
        return String.valueOf(base) + ++max;
    }
}

