/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.diagram.common.locator.PortPositionLocatorUtils;

public class FixPortLocationCommand
extends AbstractTransactionalCommand {
    private final Rectangle proposedLocation;
    private final Rectangle validLocation;
    private Shape borderItemShape;
    private Bounds borderItemBounds;

    public FixPortLocationCommand(TransactionalEditingDomain domain, IBorderItemEditPart borderItemEditPart, GraphicalEditPart parentEditPart) {
        super(domain, "Fix port location command", null);
        this.borderItemShape = (Shape)borderItemEditPart.getNotationView();
        this.borderItemBounds = (Bounds)this.borderItemShape.getLayoutConstraint();
        this.proposedLocation = new Rectangle(this.borderItemBounds.getX(), this.borderItemBounds.getY(), this.borderItemBounds.getWidth(), this.borderItemBounds.getHeight());
        this.validLocation = PortPositionLocatorUtils.getBorderLocation(parentEditPart.getFigure().getBounds().getCopy(), this.proposedLocation, 10);
    }

    public boolean canExecute() {
        return !this.proposedLocation.equals((Object)this.validLocation);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.borderItemBounds.setX(this.validLocation.x);
        this.borderItemBounds.setY(this.validLocation.y);
        return CommandResult.newOKCommandResult();
    }
}

